package cn.com.duiba.activity.center.biz.dao.hdtool;


import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface DuibaHdtoolOptionsDao {
	public List<DuibaHdtoolOptionsEntity> findByHdtoolId(Long hdtoolId);

	/**
	 * 增加奖品数量
	 */
	public int addRemainingById(Long id, Integer addRemaining);

	/**
	 * 减少奖品数量
	 */
	public int subRemainingById(Long id, Integer subRemaining);

	/**
	 * 更新库存
	 */
	public int updateRemainingById(Long id, Integer remaining);

	/**
	 * 查询奖项剩余库存，加锁
	 * @param id
	 * @return
	 */
	public Integer findRemaingForupdate(Long id);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolId(Long hdtoolId);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds);

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsEntity findOptionById(Long id);

	public DuibaHdtoolOptionsEntity findOptionByIdForupdate(Long id);

	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(@Param("id") Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(@Param("id") Long id);

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 新增兑换活动工具奖项
	 */
	public void insertHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);
}
