package cn.com.duiba.activity.center.biz.dao.littlegame;

import java.util.List;
import java.util.Set;

import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;

/**
 * describe : 小游戏DAO.
 *
 * @author : cdm
 * @date : 2016年10月13日 下午5:03:10
 */
public interface LittleGameDao {

    /**
     * Select by id.
     *
     * @param id the id
     * @return the little game entity
     */
    LittleGameEntity selectById(Long id);

    /**
     * Select list.
     *
     * @param title the title
     * @param offset the offset
     * @param max the max
     * @return the list
     */
    List<LittleGameEntity> selectList(String title, int offset, int max);

    /**
     * Select count.
     *
     * @param title the title
     * @return the long
     */
    Long selectCount(String title);

    /**
     * Insert.
     *
     * @param entity the entity
     * @return the long
     */
    Long insert(LittleGameEntity entity);

    /**
     * 根据主键批量查询.
     *
     * @param ids the ids
     * @return the little game entity
     */
    List<LittleGameEntity> selectByIds(Set<Long> ids);

    /**
     * update:更新,传null不更新. <br/>
     *
     * @author wubo
     * @param entity the entity
     * @return the long
     * @since JDK 1.6
     */
    Long update(LittleGameEntity entity);

    /**
     * selectListByStatus:查询指定状态的小游戏列表. <br/>
     * 根据修改时间倒序<br>
     * 注意：会过滤掉删除的小游戏<br>
     *
     * @author zhuzhiyong
     * @param status the status
     * @param offset the offset
     * @param max the max
     * @return the list
     */
    List<LittleGameEntity> selectListByStatus(int status, int offset, int max);

    /**
     * selectCountByStatus:查询指定状态的小游戏数量. <br/>
     * 注意：会过滤掉删除的小游戏<br>
     *
     * @author zhuzhiyong
     * @param status the status
     * @return the integer
     */
    Integer countByStatus(int status);

    /**
     * updateCategory:更新分类，此参数可设为null. <br/>
     *
     * @author wubo
     * @param id the id
     * @param categoryId the category id
     * @return the int
     * @since JDK 1.6
     */
    int updateCategory(Long id, Long categoryId);
}
