/**
 * Project Name:activity-center-biz
 * File Name:ActivityPrizeOptionDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.prize
 * Date:2016年7月26日下午3:52:51
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.prize;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;

/**
 * ClassName:ActivityPrizeOptionDao <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午3:52:51 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ActivityPrizeOptionDao {

    public ActivityPrizeOptionDto find(Long id);
    /**
     * 插入奖项
     * @author zp
     * @param activityPrizeOptionDto
     * @return
     * @since JDK 1.6
     */
    public Long insert(ActivityPrizeOptionDto activityPrizeOptionDto);
    
    /**
     * 编辑奖项
     * @author zp
     * @param activityPrizeOptionDto
     * @return
     * @since JDK 1.6
     */
    public Long update(ActivityPrizeOptionDto activityPrizeOptionDto);
    
    /**
     * 删除奖项
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Boolean delete(Long id);
    
    /**
     * 根据活动id查询奖项
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigId(Long configId,String activityType);
    
    /**
     * 签到根据活动id查询给定天数的奖项
     */
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigIdAndDays(Long configId,String activityType, String otherUse);
    
    /**
     * 根据活动id查询奖项
     * @param configIds
     * @param activityType
     * @param prizeType
     * @return
     */
    public List<ActivityPrizeOptionDto> selectCouponActivityOptionsByIds(List<Long> configIds,String activityType, String prizeType);
    
    /**
     * 批量查询
     * @author wubo
     * @param configIds
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigIds(List<Long> configIds,String activityType);
    
    /**
     * 
     * selectActivityOptionsByActivityType. <br/>
     * 根据类型查询奖项
     * @author wubo
     * @param activityType
     * @param offset
     * @param max
     * @return list
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> selectActivityOptionsByActivityType(String activityType,Integer offset,Integer max);
    
    /**
     * 
     * selectCountByActivityType. <br/>
     * 统计某个奖项的类型
     * @author wubo
     * @param activityType
     * @return long
     * @since JDK 1.6
     */
    public Long selectCountByActivityType(String activityType);
    
    /**
     * 
     * selectRandomByActivityType:随机查询特定个数的某个类型的奖项.并排除某些特定的id <br/>
     *
     * @author wubo
     * @param activityType 类型
     * @param number 个数
     * @param ids 要排除的id，为null时，不排除
     * @return
     * @since JDK 1.6
     */
    public List<ActivityPrizeOptionDto> selectRandomByActivityType(String activityType,int number,List<Long> ids);
}

