/**
 * Project Name:activity-center-biz
 * File Name:ActivityPrizeOptionDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.prize.impl
 * Date:2016年7月26日下午3:56:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.prize.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.prize.ActivityPrizeOptionDao;

import com.google.common.collect.Maps;

/**
 * ClassName:ActivityPrizeOptionDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午3:56:36 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class ActivityPrizeOptionDaoImpl extends ActivityBaseDao implements ActivityPrizeOptionDao{

    @Override
    public Long insert(ActivityPrizeOptionDto activityPrizeOptionDto) {
        insert("insert",activityPrizeOptionDto);
        return activityPrizeOptionDto.getId();
    }

    @Override
    public Long update(ActivityPrizeOptionDto activityPrizeOptionDto) {
        update("update", activityPrizeOptionDto);
        return activityPrizeOptionDto.getId();
    }

    @Override
    public Boolean delete(Long id) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", id);
        return 1 == delete("del", map);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigId(Long configId,String activityType) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("configId", configId);
        map.put("activityType", activityType);
        return selectList("selectActivityOptionsByConfigId",map);
    }
    
    @Override
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigIdAndDays(Long configId,String activityType, String otherUse) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("configId", configId);
        map.put("activityType", activityType);
        map.put("otherUse", otherUse);
        return selectList("selectActivityOptionsByConfigIdAndDays",map);
    }
    
    @Override
    public List<ActivityPrizeOptionDto> selectCouponActivityOptionsByIds(List<Long> configIds,String activityType, String prizeType) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("ids", configIds);
        map.put("activityType", activityType);
        map.put("prizeType", prizeType);
        return selectList("selectCouponActivityOptionsByIds",map);
    }

    @Override
    public ActivityPrizeOptionDto find(Long id) {
        Map<String,Object> param = Maps.newHashMap();
        param.put("id", id);
        return selectOne("find",param);
    }

    @Override
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigIds(List<Long> configIds, String activityType) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("configIds", configIds);
        map.put("activityType", activityType);
        return selectList("selectActivityOptionsByConfigIds",map);
    }

    @Override
    public List<ActivityPrizeOptionDto> selectActivityOptionsByActivityType(String activityType, Integer offset, Integer max) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("activityType", activityType);
        map.put("offset", offset);
        map.put("max", max);
        return selectList("selectActivityOptionsByActivityType",map);
    }

    @Override
    public Long selectCountByActivityType(String activityType) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("activityType", activityType);
        return selectOne("selectCountByActivityType",map);
    }

    @Override
    public List<ActivityPrizeOptionDto> selectRandomByActivityType(String activityType, int number, List<Long> ids) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("activityType", activityType);
        map.put("number", number);
        map.put("ids", ids);
        return selectList("selectRandomByActivityType",map);
    }
    

}

