package cn.com.duiba.activity.center.biz.dao.seckill.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigDao;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository("duibaSeckillStockConfigDao")
public class DuibaSeckillStockConfigDaoImpl extends ActivityBaseDao implements DuibaSeckillStockConfigDao {

	@Override
	public DuibaSeckillStockConfigEntity find(Long id) {
		return selectOne("find", id);
	}

	@Override
	public DuibaSeckillStockConfigEntity findForUpdate(Long id) {
		return selectOne("findForUpdate", id);
	}

	@Override
	public DuibaSeckillStockConfigEntity findByUnique(Long seckillId, Long appId) {
		Map<String,Object> params = Maps.newHashMap();
		params.put("seckillId", seckillId);
		params.put("appId", appId);
		return selectOne("findByUnique", params);
	}

	@Override
	public int consumeStock(Long id) {
		Map<String,Object> params = Maps.newHashMap();
		params.put("id", id);
		return update("consumeStock", params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.SECKILL;
	}
}
