/**
 * Project Name:activity-center-biz
 * File Name:SignConfigDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.sign.impl
 * Date:2016年10月22日下午1:41:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.sign.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.sign.SignConfigDao;
import cn.com.duiba.activity.center.biz.entity.sign.SignConfigEntity;

import com.google.common.collect.Maps;

/**
 * ClassName:SignConfigDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年10月22日 下午1:41:48 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class SignConfigDaoImpl extends ActivityBaseDao implements SignConfigDao {

    @Override
    public List<SignConfigEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("ids", ids);
        return selectList("findAllByIds", params);
    }

    @Override
    public List<SignConfigEntity> findByPage(Long appId, Integer offset, Integer max, String title, Integer id) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("appId", appId);
        params.put("id", id);
        params.put("title", title);
        params.put("offset", offset);
        params.put("max", max);
        return selectList("findByPage", params);
    }

    @Override
    public Long findByPageCount(Long appId, String title, Integer id) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("appId", appId);
        params.put("id", id);
        params.put("title", title);
        return selectOne("findByPageCount", params);
    }

    @Override
    public SignConfigEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public void add(SignConfigEntity sign) {
        insert("add", sign);
    }

    @Override
    public void delete(Long id) {
        update("delete", id);
    }

    @Override
    public void update(SignConfigEntity sign) {
        update("update", sign);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", status);
        return update("updateStatus", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

}

