/**
 * Project Name:activity-center-biz
 * File Name:ActivityOptionsStockPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.stock
 * Date:2016年7月29日下午3:57:16
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.stock.service.api.constant.ConsumeStockTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.google.common.collect.Lists;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * ClassName:ActivityOptionsStockPluginImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午3:57:16 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityOptionsStockPluginImpl implements InitializingBean{
    
    private static Logger log = LoggerFactory.getLogger(ActivityOptionsStockPluginImpl.class);
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;

    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){

        private static final String ACTIVITY_CONSUME_STOCK = "__activity_ward_stock_consume";
        
        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
            
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                        ActivityOrderPluginContext context) throws Exception {
                if (!option.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)
                        && !option.getPrizeType().equals(ItemDO.LuckyBag)){
                try{
                    if (ActivityOrderDto.TypeElasticGifts.equals(order.getActivityType())) {
                        return; // 弹层活动没有奖项,所以此处不做操作
                    }
                   List<Long> stockIds = Lists.newArrayList();
                   if(ActivityOrderDto.TypePlugin.equals(order.getActivityType())){
                       stockIds.add(option.getStockId());
                   }else{
                       ActPreStockDto preStock = actPreStockSerivce.findPreStockByApp(option.getId(), ActivityPrizeOptionDto.Activity_Type_Rob, order.getAppId());
                       if(null != preStock){
                           stockIds.add(preStock.getPrizeQuantity());
                       }else{
                           stockIds.add(option.getStockId());
                       }
                   }
                   DubboResult<Boolean> con = remoteStockService.consumeStock(ConsumeStockTypes.ActivityOrder.getType(), order.getOrderNum(),stockIds);
                   if(!con.isSuccess() || con.getResult() == null || !con.getResult()){
                       throw new Exception("活动减奖项库存失败");
                   }
                   context.setAttribute(ACTIVITY_CONSUME_STOCK, true);
                }catch(Exception e){
                   log.error("className: "+this.getClass().getName()+" method: consumnActivityOptionStock,减奖项库存失败",e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option,
                                                 Exception exception, ActivityOrderPluginContext context) {
            if (!option.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)
                    && !option.getPrizeType().equals(ItemDO.LuckyBag)){
                try{
                    if (ActivityOrderDto.TypeElasticGifts.equals(order.getActivityType())) {
                        return; // 弹层活动没有奖项,所以此处不做操作
                    }
                    Boolean hasadd=(Boolean) context.getAttribute(ACTIVITY_CONSUME_STOCK);
                    if(hasadd!=null && hasadd){
                        DubboResult<Boolean> con = remoteStockService.rollbackStock(ConsumeStockTypes.ActivityOrder.getType(),order.getOrderNum());
                        if(!con.isSuccess() || con.getResult() == null || !con.getResult()){
                            throw new Exception("活动返预分配库存失败");
                        }
                    }
                    context.remove(ACTIVITY_CONSUME_STOCK);
                }catch(Exception e){
                    log.error("className: "+this.getClass().getName()+" method: paybackActivityOptionStock,返奖项库存失败",e);
                }
            }
            
        }
        
    };
    
    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(orderPlugin);
    }

}

