package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteActivityConsumerLimitService;
import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by houwen on 16/8/11.
 */
@Service
public class RemoteActivityConsumerLimitServiceImpl implements RemoteActivityConsumerLimitService {

	private static final Logger log = LoggerFactory.getLogger(RemoteActivityConsumerLimitServiceImpl.class);

	@Autowired
	private ConsumerActivityLimitService consumerActivityLimitService;

	@Override
	public DubboResult<Integer> findConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		try {
			Integer num = consumerActivityLimitService.findConsumerJoinNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(num);
		} catch (Exception e) {
			log.error("findConsumerJoinNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.incrConsumerJoinNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("incrConsumerJoinNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.decrConsumerJoinNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("decrConsumerJoinNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Integer> findConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		try {
			Integer num = consumerActivityLimitService.findConsumerJoinNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(num);
		} catch (Exception e) {
			log.error("findConsumerJoinNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.incrConsumerJoinNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("incrConsumerJoinNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.decrConsumerJoinNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("decrConsumerJoinNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Integer> findConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		try {
			Integer num = consumerActivityLimitService.findConsumerFreeNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(num);
		} catch (Exception e) {
			log.error("findConsumerFreeNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.incrConsumerFreeNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("incrConsumerFreeNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.decrConsumerFreeNumToday(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("decrConsumerFreeNumToday", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Integer> findConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		try {
			Integer num = consumerActivityLimitService.findConsumerFreeNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(num);
		} catch (Exception e) {
			log.error("findConsumerFreeNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.incrConsumerFreeNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("incrConsumerFreeNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		try {
			boolean ret = consumerActivityLimitService.decrConsumerFreeNumForever(consumerId, operatingActivityId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("decrConsumerFreeNumForever", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Integer> findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
		try {
			Integer num = consumerActivityLimitService.findConsumerWinOptionNum(consumerId, operatingActivityId, optionId);
			return DubboResult.successResult(num);
		} catch (Exception e) {
			log.error("findConsumerWinOptionNum", e);
			return DubboResult.failResult("系统异常");
		}
	}

	@Override
	public DubboResult<Boolean> incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
		try {
			boolean ret = consumerActivityLimitService.incrConsumerWinOptionNum(consumerId, operatingActivityId, optionId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("incrConsumerWinOptionNum", e);
			return DubboResult.failResult("系统异常");
		}
	}

}
