/**
 * Project Name:activity-center-biz
 * File Name:RemoteOperatingHdtoolNewServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.activity
 * Date:2016年11月18日下午4:45:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.javatuples.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingHdtoolNewService;
import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteOperatingHdtoolNewServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年11月18日 下午4:45:05 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteOperatingHdtoolNewServiceImpl implements RemoteOperatingHdtoolNewService{

    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private DuibaHdtoolOptionsService duibaHdtoolOptionsService;
    @Resource
    private OperatingActivityOptionsService operatingActivityOptionsService;
    @Autowired
    private ConsumerActivityLimitService consumerActivityLimitService;
    
    @Override
    public DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexValid(Long operatingActivityId,Long appId) {
        try{
            OperatingActivityDto opertingActivity = operatingActivityService.find(operatingActivityId);
            if(null == opertingActivity || opertingActivity.getDeleted()){
                return DubboResult.failResult("活动不存在或活动不可用");
            }
            if(!opertingActivity.getAppId().equals(appId)){
                return DubboResult.failResult("无权限参与活动");
            }
            DuibaHdtoolDto duibaHdtool = null;
            if(opertingActivity.getActivityId() != null && OperatingActivityDto.isHdTool(opertingActivity.getType())){
                duibaHdtool = duibaHdtoolService.find(opertingActivity.getActivityId());
                if(null == duibaHdtool || duibaHdtool.getStatus() != DuibaHdtoolDto.STATUS_OPEN || duibaHdtool.getDeleted()){
                    return DubboResult.failResult("兑吧活动不存在或活动不可用");
                }
            }
            return DubboResult.successResult(Pair.with(opertingActivity, duibaHdtool));
        }catch(Exception e){
            return DubboResult.failResult("无权限参与活动");
        }
    }

    @Override
    public DubboResult<List<HdtoolOptionsDto>> findHdtoolOptions(OperatingActivityDto operatingActivityDO) {
        try{
            List<HdtoolOptionsDto> options = new ArrayList<HdtoolOptionsDto>();
            if(operatingActivityDO.getActivityId() != null && OperatingActivityDto.isHdTool(operatingActivityDO.getType())){
                // 兑吧活动工具奖项
                List<DuibaHdtoolOptionsDto> duibaOptions = duibaHdtoolOptionsService.findOptionsByDuibaHdtoolId(operatingActivityDO.getActivityId());
                for (DuibaHdtoolOptionsDto option : duibaOptions) {
                    HdtoolOptionsDto vo = new HdtoolOptionsDto();
                    vo.setId(option.getId());
                    vo.setDuibaHdtoolId(option.getDuibaHdtoolId());
                    vo.setName(option.getName());
                    vo.setPayload(option.getPayload());
                    vo.setAppItemId(option.getAppItemId());
                    vo.setItemId(option.getItemId());
                    vo.setPrizeType(option.getPrizeType());
                    vo.setFacePrice(option.getFacePrice());
                    vo.setLogo(option.getLogo());
                    vo.setRemaining(option.getRemaining());
                    vo.setRate(option.getRate());
                    vo.setHidden(option.getHidden());
                    vo.setDescription(option.getDescription());
                    vo.setLimitCount(option.getLimitCount());
                    vo.setMinComein(option.getMinComein());
                    vo.setDeleted(option.getDeleted());
                    vo.setGmtCreate(option.getGmtCreate());
                    vo.setGmtModified(option.getGmtModified());
                    options.add(vo);
                }
            } else {
                // 开发者自有活动工具奖项
                List<OperatingActivityOptionsDto> appOptions = operatingActivityOptionsService.findByOperatingActivityId(operatingActivityDO.getId());
                for (OperatingActivityOptionsDto option : appOptions) {
                    HdtoolOptionsDto vo = new HdtoolOptionsDto();
                    vo.setId(option.getId());
                    vo.setOperatingActivityId(option.getOperatingActivityId());
                    vo.setName(option.getName());
                    vo.setPayload(option.getPayload());
                    vo.setAppItemId(option.getAppItemId());
                    vo.setItemId(option.getItemId());
                    vo.setPrizeType(option.getPrizeType());
                    vo.setFacePrice(option.getFacePrice());
                    vo.setLogo(option.getLogo());
                    vo.setRemaining(option.getRemaining());
                    vo.setRate(option.getRate());
                    vo.setHidden(option.getHidden());
                    vo.setDescription(option.getDescription());
                    vo.setLimitCount(option.getLimitCount());
                    vo.setMinComein(option.getMinComein());
                    vo.setDeleted(option.getDeleted());
                    vo.setGmtCreate(option.getGmtCreate());
                    vo.setGmtModified(option.getGmtModified());
                    options.add(vo);
                }
            }
            return DubboResult.successResult(options);
        }catch(Exception e){
            return DubboResult.failResult("error");
        }
    }

    @Override
    public DubboResult<Integer> getLimitCountNum(Long consumerId, OperatingActivityDto operatingActivityDO,
                                                 DuibaHdtoolDto duibaHdtool) {
        try{
            Integer limitCount = null;
            String limitScope = null;
            if (operatingActivityDO != null && duibaHdtool == null) {
                limitCount = operatingActivityDO.getLimitCount();
                limitScope = operatingActivityDO.getLimitScope();
            } else if (duibaHdtool != null) {
                limitCount = duibaHdtool.getLimitCount();
                limitScope = duibaHdtool.getLimitScope();
            }
            Integer num = null;
            if (limitCount != null && limitCount > 0) {
                if (limitScope.equals(DuibaHdtoolDto.LimitTypeEveryday)) {
                    num = consumerActivityLimitService.findConsumerJoinNumToday(consumerId, operatingActivityDO.getId());
                } else {
                    num = consumerActivityLimitService.findConsumerJoinNumForever(consumerId, operatingActivityDO.getId());
                }
                if (num != null) {
                    if (num > limitCount) {
                        return DubboResult.successResult(0);
                    }
                    num = limitCount - num;
                }
            }
            return DubboResult.successResult(num);
        }catch(Exception e){
            return DubboResult.successResult(0);
        }
    }

    @Override
    public DubboResult<Integer> getFreeLimitNum(Long consumerId, OperatingActivityDto operatingActivityDO,
                                                DuibaHdtoolDto duibaHdtool) {
        try{
            Integer freeLimit = null;
            String limitScope = null;
            if (operatingActivityDO != null && duibaHdtool == null) {
                freeLimit = operatingActivityDO.getFreeLimit();
                limitScope = operatingActivityDO.getFreeScope();
            } else if (duibaHdtool != null) {
                freeLimit = duibaHdtool.getFreeLimit();
                limitScope = duibaHdtool.getFreeScope();
            }
            Integer num = 0;
            if (freeLimit != null && freeLimit > 0) {
                if (limitScope.equals(DuibaHdtoolDto.LimitTypeEveryday)) {
                    num = consumerActivityLimitService.findConsumerFreeNumToday(consumerId, operatingActivityDO.getId());
                } else {
                    num = consumerActivityLimitService.findConsumerFreeNumForever(consumerId, operatingActivityDO.getId());
                }
                if(num != null){
                    if (num > freeLimit) {
                        return DubboResult.successResult(0);
                    }
                    num = freeLimit - num;
                }
            }
            return DubboResult.successResult(num);
        }catch(Exception e){
            return DubboResult.successResult(0);
        }
    }
}

