/**
 * Project Name:activity-center-biz
 * File Name:RemoteCreditGameSkinTemplateServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame
 * Date:2016年9月13日下午4:34:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameSkinTemplateDto;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameSkinTemplateService;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameSkinTemplateEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameSkinTemplateService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteCreditGameSkinTemplateServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年9月13日 下午4:34:56 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteCreditGameSkinTemplateServiceImpl implements RemoteCreditGameSkinTemplateService{
    
    @Resource
    private CreditGameSkinTemplateService creditGameSkinTemplateService;
    
    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameSkinTemplateServiceImpl.class);

    @Override
    public DubboResult<CreditGameSkinTemplateDto> find(Long id) {
        CreditGameSkinTemplateDto rs;
        try{
            Preconditions.checkNotNull(id,"id is null");
            CreditGameSkinTemplateEntity entity = this.creditGameSkinTemplateService.queryById(id);
            if(entity!=null){
                rs = new CreditGameSkinTemplateDto();
                ObjectUtil.convert(entity, rs);
            }else{
                rs = null;
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("find() error,id="+id,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<CreditGameSkinTemplateDto>> findPage(PagingParameters pagingParameters) {
        List<CreditGameSkinTemplateDto> rs;
        try{
            Integer offset = pagingParameters.getOffset();
            Integer max = pagingParameters.getMax();
            if(offset==null){
                offset = 0;
            }
            if(max == null){
                max = 20;
            }
            List<CreditGameSkinTemplateEntity> entity = this.creditGameSkinTemplateService.queryByPage(offset, max);
            if(CollectionUtils.isNotEmpty(entity)){
                rs = Lists.newArrayListWithCapacity(entity.size());
                ObjectUtil.convertList(entity, rs, CreditGameSkinTemplateDto.class);
            } else {
                rs = Lists.newArrayList();
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("findPage() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> add(CreditGameSkinTemplateDto dto) {
        try{
            Preconditions.checkNotNull(dto,"dto is null");
            CreditGameSkinTemplateEntity entity = new CreditGameSkinTemplateEntity();
            ObjectUtil.convert(dto, entity);
            int record = this.creditGameSkinTemplateService.insert(entity);
            if(record==1){
                return DubboResult.successResult(Boolean.TRUE);
            } else {
                return DubboResult.failResult("添加记录为"+record);
            }
        } catch (Exception e){
            log.error("add() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> edit(CreditGameSkinTemplateDto dto) {
        try{
            Preconditions.checkNotNull(dto,"dto is null");
            CreditGameSkinTemplateEntity entity = new CreditGameSkinTemplateEntity();
            ObjectUtil.convert(dto, entity);
            int record = this.creditGameSkinTemplateService.update(entity);
            if(record==1){
                return DubboResult.successResult(Boolean.TRUE);
            } else {
                return DubboResult.failResult("更新记录为"+record);
            }
        } catch (Exception e){
            log.error("edit() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> isTitleExist(String name) {
        try{
            boolean rs;
            Preconditions.checkNotNull(name,"name is null");
            Long count = this.creditGameSkinTemplateService.queryCountByName(name);
            rs = count > 0;
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("isTitleExist() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    @Override
    public DubboResult<List<CreditGameSkinTemplateDto>> findByType(Byte type) {
        List<CreditGameSkinTemplateDto> rs;
        try{
            Preconditions.checkNotNull(type,"type is null");
            List<CreditGameSkinTemplateEntity> entity = this.creditGameSkinTemplateService.queryByType(type);
            if(CollectionUtils.isNotEmpty(entity)){
                rs = Lists.newArrayListWithCapacity(entity.size());
                ObjectUtil.convertList(entity, rs, CreditGameSkinTemplateDto.class);
            } else {
                rs = Lists.newArrayList();
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("findByType() error,type="+type,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findCount() {
        try{
            Long rs;
            rs = this.creditGameSkinTemplateService.queryCount();
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("findCount() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

