/**
 * Project Name:activity-center-biz File Name:RemoteGameCenterBackendServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter Date:2016年10月24日下午5:16:18 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterStatisticDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityListDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecenter.RemoteGameCenterBackendService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterResourceService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameCenterBackendServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月24日 下午5:16:18 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
@Service("remoteGameCenterBackendService")
public class RemoteGameCenterBackendServiceImpl implements RemoteGameCenterBackendService {

    private static final Logger       log = LoggerFactory.getLogger(RemoteGameCenterBackendServiceImpl.class);

    @Autowired
    private GameCenterResourceService gameCenterResourceService;

    @Override
    public DubboResult<GameCenterStatisticDto> findStatistic() {

        try {
            GameCenterStatisticDto gameCenterStatisticDto = gameCenterResourceService.findStatistic();
            return DubboResult.successResult(gameCenterStatisticDto);
        } catch (GameCenterException e) {
            log.error("findStatistic failed.", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<LittleGameResourceListDto> findLittleGameResource(Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = gameCenterResourceService.findLittleGameResource(offset,
                                                                                                               max);
        return DubboResult.successResult(littleGameResourceListDto);
    }

    @Override
    public DubboResult<Boolean> updateResourceLocation(Long activityId, Integer activityType,
                                                       List<String> addLocationNames, List<String> delLocationNames) {
        try {
            Boolean result = gameCenterResourceService.updateResourceLocation(activityId, activityType,
                                                                              addLocationNames, delLocationNames);
            return DubboResult.successResult(result);
        } catch (GameCenterException e) {
            log.error("updateResourceLocation failed. activityId={}, activityType={}, addLocationNames={}, delLocationNames={}",
                      activityId, activityType, addLocationNames, delLocationNames, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<RelatedActivityListDto> findRelatedActivity(Integer offset, Integer max) {
        try {
            RelatedActivityListDto relatedActivityListDto = gameCenterResourceService.findRelatedActivity(offset, max);
            return DubboResult.successResult(relatedActivityListDto);
        } catch (GameCenterException e) {
            log.error("findRelatedActivity failed. offset={}, max={}", offset, max, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> addRelatedActivity(Long activityId, Integer activityType) {
        try {
            Boolean result = gameCenterResourceService.addRelatedActivity(activityId, activityType);
            return DubboResult.successResult(result);
        } catch (GameCenterException e) {
            log.error("findRelatedActivity failed. activityId={}, activityType={}", activityId, activityType, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteRelatedActivity(Long activityId, Integer activityType) {
        Boolean result = gameCenterResourceService.deleteRelatedActivity(activityId, activityType);
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<LittleGameResourceListDto> findAvailableLittleGameByAppId(Long appId, Integer offset,
                                                                                 Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = gameCenterResourceService.findAvailableLittleGameByAppId(appId,
                                                                                                                       offset,
                                                                                                                       max,
                                                                                                                       false);
        return DubboResult.successResult(littleGameResourceListDto);
    }

    @Override
    public DubboResult<LittleGameResourceListDto> findHiddenLittleGameByAppId(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = gameCenterResourceService.findHiddenLittleGameByAppId(appId,
                                                                                                                    offset,
                                                                                                                    max);
        return DubboResult.successResult(littleGameResourceListDto);
    }
}
