/**
 * Project Name:activity-center-biz File Name:RemoteGameSkinImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.gameskin Date:2016年9月29日下午7:18:41 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.gameskin;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.activity.center.api.remoteservice.gameskin.RemoteGameSkinService;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;
import cn.com.duiba.activity.center.biz.service.gameskin.GameSkinService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteGameSkinImpl <br/>
 * Date: 2016年9月29日 下午7:18:41 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteGameSkinServiceImpl implements RemoteGameSkinService {

    private static Logger   log = LoggerFactory.getLogger(RemoteGameSkinServiceImpl.class);

    @Resource
    private GameSkinService gameSkinService;

    @Override
    public DubboResult<GameSkinDto> find(Long id) {
        try {
            GameSkinDto rs;
            GameSkinEntity entity = this.gameSkinService.selectById(id);
            if (entity == null) {
                rs = null;
            } else {
                rs = new GameSkinDto();
                ObjectUtil.convert(entity, rs);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.find(" + id + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<GameSkinDto>> findPage(PagingParameters pagingParameters,List<Byte> types) {
        try {
            List<GameSkinDto> rs;
            Integer offset = pagingParameters.getOffset();
            Integer max = pagingParameters.getMax();
            if (offset == null) {
                offset = 0;
            }
            if (max == null) {
                max = 20;
            }
            List<GameSkinEntity> entity = this.gameSkinService.selectByPage(offset, max,types);
            if (entity == null) {
                rs = null;
            } else {
                rs = Lists.newArrayList();
                ObjectUtil.convertList(entity, rs, GameSkinDto.class);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.findPage(" + pagingParameters.getOffset() + pagingParameters.getMax()
                      + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<GameSkinDto>> findByType(Byte type) {
        try {
            List<GameSkinDto> rs;
            List<GameSkinEntity> entity = this.gameSkinService.selectByType(type);
            if (CollectionUtils.isEmpty(entity)) {
                rs = null;
            } else {
                rs = Lists.newArrayListWithCapacity(entity.size());
                ObjectUtil.convertList(entity, rs, GameSkinDto.class);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.findByType(" + type + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> add(GameSkinDto dto) {
        try {
            GameSkinEntity entity = new GameSkinEntity();
            ObjectUtil.convert(dto, entity);
            Long id = this.gameSkinService.insert(entity);
            return DubboResult.successResult(id);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.add(" + dto.toString() + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> edit(GameSkinDto dto) {
        try {
            if (dto.getId() == null) {
                throw new Exception("id is null!!!");
            }
            GameSkinEntity entity = new GameSkinEntity();
            ObjectUtil.convert(dto, entity);
            Long id = this.gameSkinService.update(entity);
            return DubboResult.successResult(id);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.edit(" + dto.toString() + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> isTitleExist(String name) {
        try {
            Boolean rs;
            Long count = this.gameSkinService.selectCount(name,null);
            if (count > 0) {
                rs = Boolean.TRUE;
            } else {
                rs = Boolean.FALSE;
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.isTitleExist(" + name + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findCount(List<Byte> types) {
        try {
            Long rs = this.gameSkinService.selectCount(null,types);
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteGameSkinService.findCount() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    
    @Override
    public DubboResult<String> getBrickContentById(Long id) {
    	try {
    		return DubboResult.successResult(gameSkinService.getBrickContentById(id));
        } catch (Exception e) {
            log.error("RemoteGameSkinService.getBrickContentById() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<GameSkinDto> findNoContent(Long id) {
        try {
    		return DubboResult.successResult(gameSkinService.findNoContent(id));
        } catch (Exception e) {
            log.error("RemoteGameSkinService.findNoContent() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
