package cn.com.duiba.activity.center.biz.remoteservice.impl.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteCreditsHdtoolOrdersService;
import cn.com.duiba.activity.center.biz.service.hdtool.CreditsHdtoolOrdersService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/30.
 */
@Service
public class RemoteCreditsHdtoolOrdersServiceImpl implements RemoteCreditsHdtoolOrdersService {
    @Resource
    private CreditsHdtoolOrdersService creditsHdtoolOrdersService;

    @Override
    public HdtoolOrdersDto find(Long consumerId, Long id) {
        return creditsHdtoolOrdersService.find(consumerId, id);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return creditsHdtoolOrdersService.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return creditsHdtoolOrdersService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return creditsHdtoolOrdersService.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return creditsHdtoolOrdersService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return creditsHdtoolOrdersService.countByConsumerIdAndPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<HdtoolOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return creditsHdtoolOrdersService.findByIds(consumerId, ids);
    }

    @Override
    public HdtoolOrdersDto findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
        return creditsHdtoolOrdersService.findByAppAndDeveloperBizId(consumerId, appId, bizId);
    }

    @Override
    public List<Long> findExpireOrder() {
        return creditsHdtoolOrdersService.findExpireOrder();
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        return creditsHdtoolOrdersService.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        return creditsHdtoolOrdersService.updateExchangeStatusToOverdue(consumerId, id, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        return creditsHdtoolOrdersService.updateStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        return creditsHdtoolOrdersService.doTakePrize(consumerId, id);
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        return creditsHdtoolOrdersService.rollbackTakePrize(consumerId, id);
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        return creditsHdtoolOrdersService.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
    }

    @Override
    public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        return creditsHdtoolOrdersService.updateLotteryLuckyResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        return creditsHdtoolOrdersService.updateDeveloperBizId(consumerId, id, bizId);
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        return creditsHdtoolOrdersService.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
    }

    @Override
    public HdtoolOrdersDto insert(HdtoolOrdersDto hdtoolOrdersDto) {
        creditsHdtoolOrdersService.insert(hdtoolOrdersDto);
        return hdtoolOrdersDto;
    }
}
