package cn.com.duiba.activity.center.biz.remoteservice.impl.remainingMoney;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.other.DuibaRemainingMoneyDO;
import cn.com.duiba.activity.center.api.remoteservice.remainingMoney.RemoteRemainingMoneyService;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteRemainingMoneyServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年11月18日 下午5:02:04 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class RemoteRemainingMoneyServiceImpl implements
		RemoteRemainingMoneyService {

	@Autowired
	private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
	
	@Override
	public DubboResult<DuibaRemainingMoneyDO> findDuibaAccountMoney() {
		return DubboResult.successResult(duibaRemainingMoneyDAO.findDuibaAccountMoney());
	}

	@Override
	public DubboResult<DuibaRemainingMoneyDO> findByDeveloperId(Long developerId) {
		return DubboResult.successResult(duibaRemainingMoneyDAO.findByDeveloperId(developerId));
	}

}
