/**
 * Project Name:activity-center-biz File Name:MultiActivityQueryingService.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter Date:2016年10月20日下午7:11:44 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter;

/**
 * ClassName:MultiActivityQueryingService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午7:11:44 <br/>
 *
 * @author Zhuzhiyong
 * @version 
 * @see 
 * @since JDK 1.6
 */
public interface MultiActivityQueryingService {

    /**
     * findActivityByTypeAndId:根据活动类型和ID查询，并过滤黑名单，定向活动，状态不正常的活动. <br/>
     * 可用于：<br>
     * <li>管理端：查询Banner已经关联活动列表，根据活动类型和ID查询具体活动信息</li>
     * <li>管理端：关联活动时，校验活动是否存在，开启</li>
     *
     * @author zhuzhiyong
     * @param activityType the activity type
     * @param activityId the activity id
     * @return the general activity item
     * @throws GameCenterException the game center exception
     */
    GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType,
                                                          Long activityId) throws GameCenterException;

    /**
     * 根据活动类型和ID查询，并过滤黑名单，定向活动，状态不正常的活动，另外，还判断是否被黑名单屏蔽.
     *
     * @param activityType the activity type
     * @param activityId the activity id
     * @param appId the app id
     * @return the general activity item
     * @throws GameCenterException the game center exception
     */
    GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType, Long activityId,
                                                          Long appId) throws GameCenterException;
}
