/**
 * Project Name:activity-center-biz File Name:GameCenterShieldServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月20日下午3:04:22 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.biz.constant.RedisKeys;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.wolf.utils.BeanUtils;
import redis.clients.jedis.JedisCommands;

/**
 * ClassName:GameCenterShieldServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午3:04:22 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class ActivityShieldServiceImpl implements ActivityShieldService {

    @Resource
    private ActivityShieldDao gameCenterShieldDao;
    @Autowired
    private JedisCommands     jedisCommands;

    @Override
    public ShieldItemDto find(Long id) {
        ActivityShieldEntity activityShieldEntity = gameCenterShieldDao.find(id);
        return BeanUtils.copy(activityShieldEntity, ShieldItemDto.class);
    }

    @Override
    public List<ShieldItemDto> findShieldList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(gameCenterShieldDao.findShieldList(paramMap), ShieldItemDto.class);
    }

    @Override
    public Integer countShield(Map<String, Object> paramMap) {

        return gameCenterShieldDao.countShield(paramMap);
    }

    @Override
    public boolean isExist(Long appId, Integer activityType, Long activityId) {
        String key = RedisKeys.ACTIVITY_CENTER_GAMECENTER_SHIELD + String.valueOf(appId) + "."
                     + String.valueOf(activityType) + "." + String.valueOf(activityId);
        String resultStr = getCache(key);
        if (StringUtils.isNotEmpty(resultStr)) {
            return Boolean.valueOf(resultStr);
        }
        ActivityShieldEntity activityShieldEntity = gameCenterShieldDao.findShield(appId, activityType, activityId);
        boolean result = activityShieldEntity != null;
        putCache(key, String.valueOf(result));
        return result;
    }

    @Override
    public Long addShield(ShieldItemDto shieldItemDto) {
        return gameCenterShieldDao.insert(BeanUtils.copy(shieldItemDto, ActivityShieldEntity.class));
    }

    @Override
    public Boolean removeShield(Long shieldId) {
        return gameCenterShieldDao.delete(shieldId) == 1;
    }

    private String getCache(String key) {
        return jedisCommands.get(key);
    }

    private void putCache(String key, String value) {
        jedisCommands.set(key, value, "NX", "EX", 60L);
    }

    @Override
    public List<ActivityShieldEntity> findShields(Long appId, Integer activityType, Set<Long> activityIds,
                                                  boolean useCache) {
        if (useCache) {
            String key = buildKey(appId, activityType, activityIds);
            String entityListStr = getCache(key);
            if (StringUtils.isNotEmpty(entityListStr)) {
                return JSON.parseArray(entityListStr, ActivityShieldEntity.class);
            }
            List<ActivityShieldEntity> activityShieldEntityies = gameCenterShieldDao.findShields(appId, activityType,
                                                                                                 activityIds);
            putCache(key, JSON.toJSONString(activityShieldEntityies));
            if (CollectionUtils.isEmpty(activityShieldEntityies)) {
                return Collections.emptyList();
            }
            return activityShieldEntityies;
        } else {
            return gameCenterShieldDao.findShields(appId, activityType, activityIds);
        }
    }

    private String buildKey(Long appId, Integer activityType, Set<Long> activityIds) {
        // 先排序，元素相同仅顺序不同的条件命中同一个缓存
        List<Long> activityIdList = new ArrayList<Long>(activityIds);
        Collections.sort(activityIdList);
        StringBuilder keyBuilder = new StringBuilder(RedisKeys.ACTIVITY_CENTER_GAMECENTER_SHIELDS).append(appId).append('.').append(activityType).append('.');
        for (Long activityId : activityIdList) {
            keyBuilder.append(activityId).append('.');
        }
        // 去掉最后一个‘.’
        return keyBuilder.substring(0, keyBuilder.length() - 1);
    }
}
