/**
 * Project Name:activity-center-biz File Name:ActivityCategoryRelationServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.impl Date:2016年6月8日下午5:07:24 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryRelationDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;

/**
 * ClassName:ActivityCategoryRelationServiceImpl <br/>
 * Date: 2016年6月8日 下午5:07:24 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
@Transactional(DsConstants.DATABASE_CREDITS_ACTIVITY)
public class ActivityCategoryRelationServiceImpl implements ActivityCategoryRelationService {

    private static final Logger         log = LoggerFactory.getLogger(ActivityCategoryRelationServiceImpl.class);
    @Autowired
    private ActivityCategoryRelationDao activityCategoryRelationDao;

    @Override
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId) {
        return this.activityCategoryRelationDao.selectByAppCategory(appId, categoryId);
    }

    @Override
    public boolean sortActivities(List<CategoryActivityDto> activities) {
        boolean rs = true;
        try {
            for (CategoryActivityDto dto : activities) {
                if (1 == this.activityCategoryRelationDao.updatePayload(dto.getId(), dto.getPayload())) {
                    continue;
                } else {
                    rs = false;
                }
            }
        } catch (Exception e) {
            rs = false;
            log.error("更新权重值出错", e);
        }
        return rs;
    }

    @Override
    public boolean save(ActivityCategoryRelationEntity entity) {
        boolean success = false;
        int rs = this.activityCategoryRelationDao.insert(entity);
        if (rs == 1) {
            success = true;
        }
        return success;
    }

    /**
     * 这里方法有bug，DAO的delete，返回是个int类型。肯定是true。不存在false的情况，不知道这个方法在哪里用到
     * @param operatingActivityId
     * @return
     */
    @Override
    public boolean remove(long operatingActivityId) {
        boolean rs;
        try {
            this.activityCategoryRelationDao.deleteByOperatingActivityId(operatingActivityId);
            rs = true;
        } catch (Exception e) {
            log.error("activityCategoryRelationDao.deleteByOperatingActivityId(" + operatingActivityId + ") error", e);
            throw e;
        }
        return rs;
    }

    @Override
    public ActivityCategoryRelationEntity findByOperatingActivityId(long operatingActivityId) {
        ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
        entity.setOperatingActivityId(operatingActivityId);
        List<ActivityCategoryRelationEntity> list = this.activityCategoryRelationDao.selectWithConditions(entity);
        if (list != null && list.size() > 0) {
            return list.get(0);
        } else {
            return null;
        }
    }

    @Override
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId, int start, int pageSize) {
        return this.activityCategoryRelationDao.selectByAppCategory(appId, categoryId, start, pageSize);
    }

    @Override
    public boolean updateActivityCategoryRelation(Long categoryId, List<OperatingActivityDto> operatingActivityList) {
        List<Long> idList = Lists.newArrayList();
        for (OperatingActivityDto dto : operatingActivityList) {
            idList.add(dto.getId());
        }
        activityCategoryRelationDao.deleteByOperatingActivityIdList(idList);
        if (categoryId != null) {
            ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
            for (OperatingActivityDto dto : operatingActivityList) {
                entity.setAppId(dto.getAppId());
                entity.setCategoryId(categoryId);
                entity.setOperatingActivityId(dto.getId());
                entity.setPayload(0);
                activityCategoryRelationDao.insert(entity);
            }
        }
        return true;
    }

}
