package cn.com.duiba.activity.center.biz.service.notify.impl;

import java.util.Date;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.service.hdtool.CreditsHdtoolOrdersService;
import cn.com.duiba.activity.center.biz.service.notify.NotifyQueueameService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;

/** 
 * ClassName:NotifyQueueameServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年11月18日 下午5:08:43 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class NotifyQueueameServiceImpl implements NotifyQueueameService {
	
	private static Logger log = LoggerFactory.getLogger(NotifyQueueameServiceImpl.class);
	
	@Autowired @Qualifier("notifyQueueDAO")
	private NotifyQueueDAOImpl notifyQueueDAO;
	@Resource
	private CreditsHdtoolOrdersService creditsHdtoolOrdersService;
	@Resource
	private RemoteConsumerService remoteConsumerService;
	@Autowired
	private NotifyCenterServiceClient notifyCenterServiceClient;

	@Override
	public void insertHdtoolOrderNotifyQueueIfNesscery(Long consumerId,Long hdtoolOrderId) {
		try {
			HdtoolOrdersDto hdtoolOrder = creditsHdtoolOrdersService.find(consumerId, hdtoolOrderId);
			if (hdtoolOrder.getCredits() <= 0) {
				return;
			}
			if (hdtoolOrder.getStatus() != HdtoolOrdersDto.StatusSuccess && hdtoolOrder.getStatus() != HdtoolOrdersDto.StatusFail) {
				return;
			}

			ConsumerDO consumer=remoteConsumerService.find(hdtoolOrder.getConsumerId());
			
			NotifyQueueDO nq=new NotifyQueueDO();
			nq.setAppId(hdtoolOrder.getAppId());
			nq.setConsumerId(hdtoolOrder.getConsumerId());
			nq.setDeveloperBizId(hdtoolOrder.getDeveloperBizId());
			nq.setDuibaOrderNum(HdtoolOrdersDto.generateOrderNum(hdtoolOrderId));
			if (hdtoolOrder.getError4Developer() != null) {
				nq.setError4developer(hdtoolOrder.getError4Developer());
			}
			nq.setNextTime(new Date());
			nq.setPartnerUserId(consumer.getPartnerUserId());
			nq.setRelationId(hdtoolOrderId);
			nq.setRelationType(NotifyQueueDO.RTHdtoolOrder);
			nq.setResult(HdtoolOrdersDto.StatusSuccess == hdtoolOrder.getStatus());
			nq.setTimes(0);
			notifyQueueDAO.insert(nq);
			
			notifyCenterServiceClient.notifyImmediately(nq.getId());
		} catch (Exception e) {
			log.error("insertHdtoolOrderNotifyQueueIfNesscery error",e);
		}
	}

}
