package cn.com.duiba.activity.center.biz.service.plugin.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginVistDao;
import cn.com.duiba.activity.center.biz.entity.plugin.ActivityPluginVistEntity;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginVistService;

/** 
 * ClassName:ActivityPluginVistServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年11月1日 下午5:15:43 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class ActivityPluginVistServiceImpl implements ActivityPluginVistService {

	@Autowired
	private ActivityPluginVistDao activityPluginVistDao;
	
	@Override
	public Integer updateActivityPluginInfo(Long id, Integer activityType) {
		return activityPluginVistDao.updateActivityPluginInfo(id, activityType);
	}

	@Override
	public ActivityPluginVistEntity findByActivityIdAndType(Long id, Integer activityType) {
	    if(null == activityType) {
	        activityType = 0;
	    }
		ActivityPluginVistEntity entity = activityPluginVistDao.findByActivityIdAndType(id, activityType);
		if(entity == null){
			entity =new ActivityPluginVistEntity(true);
			entity.setPluginId(id);
			entity.setActivityType(activityType);
			activityPluginVistDao.createActivityPluginInfo(entity);
		}
		return entity;
	}

}
