package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzEntity;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/13.
 */
@Service
public class DuibaQuizzServiceImpl implements DuibaQuizzService {

    @Resource
    private DuibaQuizzDao duibaQuizzDao;
    
    @Autowired
	private CacheClient         cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_DUIBA_QUIZZ_BY_ID + id;
    }

    @Override
    public DuibaQuizzDto find(Long id) {
    	String key = getCacheKeyById(id);
    	DuibaQuizzDto d = cacheClient.get(key);
    	if (d == null) {
    		DuibaQuizzEntity entity = duibaQuizzDao.find(id);
    		if (entity == null) {
                return null;
            }

            d = BeanUtils.copy(entity, DuibaQuizzDto.class);
            int cacheTime = 300;
            cacheClient.set(key, d, cacheTime);
    	}
    	return d;
    }
    
    @Override
    public String findTagById(Long id) {
        return duibaQuizzDao.findTagById(id);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Integer offset, Integer max) {

        List<DuibaQuizzEntity> byPage = duibaQuizzDao.findByPage(offset, max);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return duibaQuizzDao.findPageCount(paramMap);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return Collections.emptyList();
        }

        List<DuibaQuizzEntity> byPage = duibaQuizzDao.findByPage(paramMap);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public int updateStatus(Long id, int status) {
        int num = duibaQuizzDao.updateStatus(id, status);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public int delete(Long id) {
        int num = duibaQuizzDao.delete(id);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public int insert(DuibaQuizzDto duibaQuizzDto) {
        Preconditions.checkNotNull(duibaQuizzDto);

        DuibaQuizzEntity entity = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        int num = duibaQuizzDao.insert(entity);
        duibaQuizzDto.setId(entity.getId());
        return num;
    }

    @Override
    public int updateInfoForm(DuibaQuizzDto duibaQuizzDto) {
        DuibaQuizzEntity entity = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        int num = duibaQuizzDao.updateInfoForm(entity);
        cacheClient.remove(getCacheKeyById(duibaQuizzDto.getId()));
        return num;
    }
    
    @Override
    public int updateTagById(Long id, String tag) {
        int num = duibaQuizzDao.updateTagById(id, tag);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int num = duibaQuizzDao.updateAutoOffDateNull(id);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public int updateSwitches(Long id, Long switches) {
        int num = duibaQuizzDao.updateSwitches(id, switches);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public List<DuibaQuizzDto> findAutoOff() {
        List<DuibaQuizzEntity> autoOff = duibaQuizzDao.findAutoOff();
        if (CollectionUtils.isEmpty(autoOff)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(autoOff, DuibaQuizzDto.class);
    }

    @Override
    public List<DuibaQuizzDto> findAllByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }

        List<DuibaQuizzEntity> allByIds = duibaQuizzDao.findAllByIds(ids);
        if (CollectionUtils.isEmpty(allByIds)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(allByIds, DuibaQuizzDto.class);

    }

    @Override
    public List<AddActivityDto> findAllQuizz() {

        List<AddActivityEntity> allQuizz = duibaQuizzDao.findAllQuizz();
        if (CollectionUtils.isEmpty(allQuizz)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(allQuizz, AddActivityDto.class);
    }

    @Override
    public int update(DuibaQuizzDto duibaQuizzDto) {

        Preconditions.checkNotNull(duibaQuizzDto);

        DuibaQuizzEntity copy = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        int num = duibaQuizzDao.update(copy);
        cacheClient.remove(getCacheKeyById(duibaQuizzDto.getId()));
        return num;
    }
}
