package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockManualChangeDao;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockManualChangeDto;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockManualChangeEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzStockManualChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by xuezhaoming on 16/6/15.
 */
@Service
public class DuibaQuizzStockManualChangeServiceImpl implements DuibaQuizzStockManualChangeService {

    @Resource
    private DuibaQuizzStockManualChangeDao duibaQuizzStockManualChangeDao;

    @Override
    public List<DuibaQuizzStockManualChangeDto> findByStockId(Long quizzStockId) {
        return BeanUtils.copyList(duibaQuizzStockManualChangeDao.findByStockId(quizzStockId),
                                  DuibaQuizzStockManualChangeDto.class);
    }

    @Override
    public void addBatch(List<DuibaQuizzStockManualChangeDto> list) {
    	List<DuibaQuizzStockManualChangeEntity> entityList = BeanUtils.copyList(list, DuibaQuizzStockManualChangeEntity.class);
        duibaQuizzStockManualChangeDao.addBatch(entityList);
        list = BeanUtils.copyList(entityList, DuibaQuizzStockManualChangeDto.class);
    }

    @Override
    public void add(DuibaQuizzStockManualChangeDto quizzStockManualChangeDO) {
    	DuibaQuizzStockManualChangeEntity entity = BeanUtils.copy(quizzStockManualChangeDO,DuibaQuizzStockManualChangeEntity.class);
        duibaQuizzStockManualChangeDao.add(entity);
        quizzStockManualChangeDO.setId(entity.getId());
    }
}
