package cn.com.duiba.activity.center.biz.service.rob;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.api.enums.PushStatusEnum;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;

/**
 * 
 * Author ：zhengjy <br/>
 * Create Time：2016年9月30日 上午8:59:01 <br/>
 */
public interface TodayRobSeckillService {
	/**
	 * 查询秒杀区间下秒杀活动列表
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	List<TodayRobSeckillConfigEntity> findSeckillConfigs(Long todayRobSeckillId);
	/**
	 *  批量查询秒杀区间下秒杀活动列表 
	 * @param todayRobSeckillId
	 * @return
	 */
	List<TodayRobSeckillConfigEntity> findSeckillConfigByIdss(List<Long> todayRobSeckillIds);
	
	/**
	 * 查询秒杀区间Dto
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	TodayRobSeckillEntity findSeckillById(Long todayRobSeckillId);
	
	/**
	 * 批量插入秒杀配置项  秒杀活动
	 * @param insertParamList
	 * @return
	 */
	Boolean  saveSeckillConfigBatch(List<TodayRobSeckillConfigEntity> insertParamList);
	
	/**
	 * 批量更新秒杀配置项  秒杀活动
	 * @param updateParamList 
	 * @return
	 */
	Boolean  updateSeckillConfigBatch(List<TodayRobSeckillConfigEntity> updateParamList);
	/**
	 * 批量删除秒杀配置项  秒杀活动
	 * @param delIds 
	 * @return
	 */
	Boolean  delSeckillConfigBatch(List<Long> delIds);
	
	
	/**
     * 分页查询秒杀区间列表
     *
     * @param pageNum  第几页
     * @param pageSize 每页展示数量
     * @return
     */
    List<TodayRobSeckillEntity> findTodayRobSeckillList(int pageNum, int pageSize);
    /**
     * 查询秒杀区间Count
     * @return
     */
    Long findTodayRobSeckillCount();
	

    /**
     * 删除秒杀区间
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @return
     */
    Boolean delTodayRobSeckill(long todayRobSeckillId);
	
	
    /**
     * 停用/启用秒杀区间
     * 启动时，需要扫描秒杀活动是否推送过，没有推送需要推送到开发库
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @param enable  true-启用；false-停用
     * @return
     */
    Boolean enableTodayRobSeckill(long todayRobSeckillId, boolean enable);

    /**
     * 根据兑吧秒杀活动ID查询区间内推送过的记录(push_time is not null)
     *
     * @author zhanglihui
     * @param activityId 秒杀活动ID
     * @return
     * @since JDK 1.6
     */
    TodayRobSeckillConfigEntity findPushedActivity(Long activityId);

    /**
     * 更新活动推送状态和时间
     *
     * @author zhanglihui
     * @param todayRobSeckillConfigId 活动配置主键
     * @param pushStatus              推送状态
     * @since JDK 1.6
     */
    void updatePushStatus(Long todayRobSeckillConfigId, PushStatusEnum pushStatus);

    /**
     * 停用指定时间之前的秒杀区间
     *
     * @author zhanglihui
     * @param date  该时间以前的秒杀区间会被停用
     */
    void disableActivityBeforeDate(Date date);
    
    /**
     * 查询推送未成功的秒杀活动
     * @return
     */
    List<TodayRobSeckillConfigEntity> findUnsuccessPushList();
    
    /**
     * 插入秒杀区间
     * @param trc
     */
	Boolean saveSeckill(TodayRobSeckillEntity trc);
	
	/**
	 * 更新秒杀区间
	 * @author zhengjy
	 * @param trc
	 */
	Boolean updateSeckill(TodayRobSeckillEntity trc);
	
	/**
	 * 查询距离当前时间最近的上一个秒杀区间
	 *
	 * @author zhanglihui
	 * @param showEntrance 秒杀区间展示入口 {@link SeckillShowEntranceEnum}
	 * @return
	 */
	TodayRobSeckillEntity findSeckillBeforeNow(String showEntrance);
	
	/**
	 * 查询即将开始的秒杀区间
	 *
	 * @author zhanglihui
	 * @param limit 查询数量
	 * @param showEntrance 秒杀区间展示入口 {@link SeckillShowEntranceEnum}
	 * @return
	 */
	List<TodayRobSeckillEntity> findSeckillAfterNow(int limit, String showEntrance);
	
	/**
	 * 查询当前开启的秒杀区间
	 *
	 * @author zhanglihui
	 * @return
	 * @since JDK 1.6
	 */
    List<Long> findEnableTodayRobSeckillIds();
}
