/**
 * Project Name:activity-center-biz
 * File Name:ActivityConsumerCreditsFailImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin
 * Date:2016年7月28日下午6:35:24
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.sign.event.credits.impl;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.exception.DeveloperAddFailedException;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsFailEvent.AddCreditsFailListener;
import cn.com.duiba.activity.center.biz.tools.service.SmsRemindService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppExceptionLogDO;
import cn.com.duiba.service.domain.dataobject.AppExtraDO;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.remoteservice.RemoteAppExceptionLogService;
import cn.com.duiba.service.remoteservice.RemoteAppExtraService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDeveloperService;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * ClassName:ActivityConsumerCreditsFailImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月28日 下午6:35:24 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityAddCreditsFailImpl implements AddCreditsFailListener,InitializingBean{

    private static Logger log = LoggerFactory.getLogger(ActivityAddCreditsFailImpl.class);
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private SmsRemindService smsRemindService;
    @Autowired
    private RemoteAppExtraService remoteAppExtraService;
    @Autowired
    private RemoteDeveloperService remoteDeveloperService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteAppExceptionLogService remoteAppExceptionLogService;
    
    private String getKey(Long appId){
        return MemcachedSpace.MS_CONSUME_CREDITS_FAIL_ALARM+"-"+appId;
    }
    
    private String getFailPercentRate(Integer failNum,Integer successNum){
        NumberFormat format = NumberFormat.getPercentInstance();// 获取格式化类实例 
        format.setMinimumFractionDigits(2);// 设置小数位 
        return format.format(Double.parseDouble(failNum + "") / Double.parseDouble(successNum + failNum + ""));// 打印计算结果 
    }
    
    private boolean checkMobileNumber(String mobileNumber){
        boolean flag = false;
        try{
              Pattern regex = Pattern.compile("^[0-9]{11}$");
              Matcher matcher = regex.matcher(mobileNumber);
              flag = matcher.matches();
         }catch(Exception e){
             log.error("非电话号码,num=" + mobileNumber,e);
             flag = false;
         }
         return flag;
    }
    
    private synchronized void checkAlarm(final Long appId,final Integer value,final Integer success){
        if(value==10 || value==50 || value==100 || value==500 || value==1000){
            ThreadPoolDuibaService.get().submit(new Runnable() {
                public void run() {
                    AppDO app = remoteAppService.find(appId);
                    String list= Environment.getConsumeFailAlarmList();
                    if(list!=null){
                        String[] phones=list.split(",");
                        for(String p:phones){
                            try {
                                String rate = getFailPercentRate(value,success);
                                String text="App "+app.getName()+"("+appId+")今日扣积分请求失败次数达到"+value+"次(共计"+(value + success)+"次,失败率="+rate+")，请确认系统是否有异常情况";
                                if(Double.parseDouble(rate.substring(0, rate.indexOf("%"))) > 1.00d){
                                    smsRemindService.sendCreditsAlarmSms(p, app.getName(),value, success);
                                }
                                log.error(text);
                            } catch (Exception e) {
                                log.error("checkAlarm error",e);
                            }
                        }
                    }
                    
                    AppExtraDO appExtra=remoteAppExtraService.findByAppId(appId);
                    if(appExtra != null && appExtra.getAlarmPhone()!=null){
                        String[] phones=appExtra.getAlarmPhone().split(",");
                        for(String p:phones){
                            if(checkMobileNumber(p)){
                                try {
                                    String text="App "+app.getName()+"("+appId+"),今日异常订单数额已达"+value+"条，请确认系统是否有异常情况";
                                    smsRemindService.sendDevExceptionAlarmSms(p, app.getName(),value);
                                    log.error(text);
                                } catch (Exception e) {
                                    log.error("checkDevExceptionAlarm error",e);
                                }
                            }else{
                                log.error(app.getName()+":"+p+"，号码错误，短信通知失败");
                            }
                            
                        }
                    }else{
                        if(app!=null && app.getDeveloperId()!=null){
                            DeveloperDO developer = remoteDeveloperService.find(app.getDeveloperId());
                            if(developer!=null && developer.getPhone()!=null){
                                if(checkMobileNumber(developer.getPhone())){
                                    try {
                                        String text="App "+app.getName()+"("+appId+"),今日异常订单数额已达"+value+"条，请确认系统是否有异常情况";
                                        smsRemindService.sendDevExceptionAlarmSms(developer.getPhone(), app.getName(),value);
                                        log.error(text);
                                    } catch (Exception e) {
                                        log.error("checkDevExceptionAlarm error",e);
                                    }
                                }else{
                                    log.error(app.getName()+":"+developer.getPhone()+"，号码错误，短信通知失败");
                                }
                            }
                        }
                        
                    }
                }
            }, ThreadPoolDuibaService.PriorityLow);
        }
    }
    
    @Override
    public void afterPropertiesSet() throws Exception {
        
    }
    
    private synchronized void plus(final Long appId){
        Integer value=(Integer) memcachedClient.get(getKey(appId));
        if(value==null){
            value=1;
            memcachedClient.set(getKey(appId), DateUtil.getToTomorrowSeconds(), value);
        }else{
            value++;
            memcachedClient.set(getKey(appId), DateUtil.getToTomorrowSeconds(), value);
        }
        Integer success = 0;
        Object suc = memcachedClient.get(MemcachedSpace.MS_CONSUME_CREDITS_SUCCESS+"-"+appId);
        if(null != suc){
            success = (Integer)suc;
        }
        checkAlarm(appId, value,success);
    }
    
    private void process(Long appId,String orderNum,String type,Exception e){
        if(e instanceof DeveloperConsumeFailedException){
            DeveloperAddFailedException dc=(DeveloperAddFailedException)e;
            if(!dc.getNormalFail()){
                plus(appId);
            }
            if(dc.getFailType() != null){
                AppExceptionLogDO exceptionLog = new AppExceptionLogDO(true);
                if(type.equals(ActivityOrderDto.TypeSign)){
                    ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
                    exceptionLog.setAppId(order.getAppId());
                    exceptionLog.setRelationId(Long.valueOf(order.getOrderNum()));
                    exceptionLog.setConsumerId(order.getConsumerId());
                    exceptionLog.setOrderNum("activity-" + order.getOrderNum());
                    exceptionLog.setRelationType(OperatingActivityDto.TypeSign);
                }
                exceptionLog.setErrorMessage(dc.getMessage());
                exceptionLog.setUrl(dc.getUrl());
                exceptionLog.setRespone(dc.getDevRespone());
                exceptionLog.setDevExceptionType(dc.getFailType());
                exceptionLog.setInterfaceType(dc.getInterfaceType());
                remoteAppExceptionLogService.insert(exceptionLog);
            }
        }else{
            plus(appId);
        }
    }

    @Override
    public void onAddActivityOrderFail(ActivityOrderDto order, Exception e) {
        process(order.getAppId(),order.getOrderNum(),order.getActivityType(),e);
    }

}

