package cn.com.duiba.activity.center.biz.sign.event.credits.impl;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.sign.event.SignEventsRegister;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsSuccessEvent.AddCreditsSuccessListener;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.wolf.cache.CacheClient;

@Component
public class AddCreditsSuccessAlarmListener implements AddCreditsSuccessListener,InitializingBean{

	@Autowired
	private CacheClient memcachedClient;
	
	@Override
	public void afterPropertiesSet() throws Exception {
		SignEventsRegister.get().registAddCreditsSuccessEvent(this);
	}
	
	private String getKey(Long appId){
		return MemcachedSpace.MS_CONSUME_CREDITS_SUCCESS + "-" + appId;
	}
	
	private synchronized void plus(final Long appId){
		Integer value=(Integer) memcachedClient.get(getKey(appId));
		if(value==null){
			value=1;
			memcachedClient.set(getKey(appId), DateUtil.getToTomorrowSeconds(), value);
		}else{
			value++;
			memcachedClient.set(getKey(appId), DateUtil.getToTomorrowSeconds(), value);
		}
	}
	

	@Override
	public void onAddOrderSuccess(ActivityOrderDto order) {
		if(order.getConsumeCredits() > 0){
			plus(order.getAppId());
		}
	}

}
