/**
 * Project Name:activity-center-biz
 * File Name:ActivityOrderPluginImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin
 * Date:2016年7月27日下午7:11:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.sign.event.order.impl;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventListener;
import cn.com.duiba.activity.center.biz.tools.service.AppTradingLimitService;
import cn.com.duiba.activity.center.biz.tools.service.TodayActivityStatisticsService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

/**
 * ClassName:ActivityOrderPluginImpl <br/>
 * Date:     2016年11月14日 下午7:11:10 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class ActivityOrderSignImpl implements InitializingBean{
    
    @Autowired
    private AppTradingLimitService appTradingLimit;
    @Autowired
    private TodayActivityStatisticsService todayActivityStatisticsService;

    @Override
    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registActivityOrdersEvent(new ActivityOrdersEventListener() {
            @Override
            public void onOrderSuccess(ActivityOrderDto order) {
                appTradingLimit.addTrading(order.getAppId());
                todayActivityStatisticsService.addTodayWinCount(order.getDuibaActivityId(),order.getActivityType(),order.getAppId());
            }
            @Override
            public void onOrderFail(ActivityOrderDto order) {
            }
            @Override
            public void onOrderCreate(ActivityOrderDto order) {
            }
        });
    }

}

