/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.kafka.callback;

import cn.com.duiba.activity.center.biz.kafka.KafkaClient;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityConsumerCreditsCallback
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityConsumerCreditsCallback.class);
    @Autowired
    private KafkaClient kafkaClient;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsService consumerCreditsService;
    private ExecutorService executorService;

    public void start() {
        if (this.executorService != null) {
            return;
        }
        int pool = 3;
        this.executorService = Executors.newFixedThreadPool(pool, new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-Activity-ConsumerCredits-" + this.i++);
            }
        });
        for (int i = 0; i < pool; ++i) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Properties props = new Properties();
                        props.put("bootstrap.servers", ActivityConsumerCreditsCallback.this.kafkaClient.getBootstrapServers());
                        props.put("group.id", "credits_consumer");
                        props.put("enable.auto.commit", "false");
                        props.put("session.timeout.ms", "30000");
                        props.put("auto.offset.reset", "earliest");
                        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        KafkaConsumer consumer = new KafkaConsumer(props);
                        consumer.subscribe(Collections.singletonList(ActivityConsumerCreditsCallback.this.topicConstant.getTopicConsumerCreditsResponse()));
                        while (!Thread.currentThread().isInterrupted()) {
                            ConsumerRecords records = consumer.poll(100L);
                            for (TopicPartition pt : records.partitions()) {
                                for (ConsumerRecord record : records.records(pt)) {
                                    try {
                                        CreditsCallbackMessage response = (CreditsCallbackMessage)JSONObject.parseObject((String)((String)record.value()), CreditsCallbackMessage.class);
                                        ActivityConsumerCreditsCallback.this.consumerCreditsService.creditsCallback(response);
                                    }
                                    catch (Exception e) {
                                        log.error("activity consumer credits error:", (Throwable)e);
                                    }
                                    finally {
                                        long lastOffset = record.offset();
                                        consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                                    }
                                }
                            }
                        }
                        consumer.close();
                    }
                    catch (Exception e) {
                        log.error("error:", (Throwable)e);
                    }
                }
            });
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

