/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCutCreditsService;
import cn.com.duiba.activity.center.biz.plugin.buckle.LittleGameConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolLotteryService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.idmaker.service.api.enums.IdempotentTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIdempotentService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LittleGameConsumerCreditsCallbackImpl
implements LittleGameConsumerCreditsCallback {
    private static Logger log = LoggerFactory.getLogger(LittleGameConsumerCreditsCallbackImpl.class);
    @Autowired
    private ConsumerCutCreditsService consumerCutCreditsService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteIdempotentService remoteIdempotentService;

    @Override
    public void cancelled(final CreditsCallbackMessage message) {
        final DeveloperConsumeFailedException exception = new DeveloperConsumeFailedException("", "\u8bf7\u6c42\u88ab\u53d6\u6d88");
        exception.setUrl(message.getHttpUrl());
        exception.setDevRespone(message.getMessage());
        exception.setFailType(1);
        exception.setInterfaceType(1);
        exception.setNormalFail(false);
        ThreadPoolLotteryService.get().submit(new Runnable(){

            @Override
            public void run() {
                LittleGameConsumerCreditsCallbackImpl.this.consumerCutCreditsService.onCreditsFail(message, exception);
            }
        });
    }

    @Override
    public void completed(final CreditsCallbackMessage message) {
        Exception exception;
        block2: {
            exception = null;
            try {
                this.successBlock(message);
            }
            catch (Exception e) {
                exception = e;
                if (e instanceof DeveloperConsumeFailedException) break block2;
                DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
                exc.setUrl(message.getHttpUrl());
                exc.setDevRespone(message.getMessage());
                exc.setDevRespone(e.getMessage());
                exc.setFailType(1);
                exc.setInterfaceType(1);
                exc.setNormalFail(false);
                exception = exc;
            }
        }
        final Exception finallyE = exception;
        ThreadPoolLotteryService.get().submit(new Runnable(){

            @Override
            public void run() {
                if (finallyE == null) {
                    LogUtil.logTodayKan((String)"ThreadPoolLotteryService run \u8fdb\u5165\u6263\u79ef\u5206success start.....");
                    LittleGameConsumerCreditsCallbackImpl.this.consumerCutCreditsService.onCreditsSuccess(message);
                    LogUtil.logTodayKan((String)"ThreadPoolLotteryService run \u8fdb\u5165\u6263\u79ef\u5206success end.....");
                } else {
                    LogUtil.logTodayKan((String)"ThreadPoolLotteryService run \u8fdb\u5165\u6263\u79ef\u5206failed start.....");
                    LittleGameConsumerCreditsCallbackImpl.this.consumerCutCreditsService.onCreditsFail(message, finallyE);
                    LogUtil.logTodayKan((String)"ThreadPoolLotteryService run \u8fdb\u5165\u6263\u79ef\u5206failed end.....");
                }
            }
        });
    }

    @Override
    public void failed(final CreditsCallbackMessage message) {
        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
        exc.setUrl(message.getHttpUrl());
        exc.setDevRespone(message.getMessage());
        exc.setFailType(1);
        exc.setInterfaceType(1);
        exc.setNormalFail(false);
        final DeveloperConsumeFailedException finallyE = exc;
        ThreadPoolLotteryService.get().submit(new Runnable(){

            @Override
            public void run() {
                LittleGameConsumerCreditsCallbackImpl.this.consumerCutCreditsService.onCreditsFail(message, finallyE);
            }
        });
    }

    private void successBlock(CreditsCallbackMessage message) throws Exception {
        String bizId;
        String orderNum;
        block9: {
            JSONObject o = null;
            try {
                o = JSON.parseObject((String)message.getMessage());
            }
            catch (Exception e) {
                log.error("json\u89e3\u6790\u5931\u8d25", (Throwable)e);
                DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5f00\u53d1\u8005\u670d\u52a1\u5668\u54cd\u5e94\u5185\u5bb9JSON\u89e3\u6790\u5931\u8d25");
                exc.setUrl(message.getHttpUrl());
                exc.setDevRespone(message.getMessage());
                exc.setFailType(3);
                exc.setInterfaceType(1);
                exc.setNormalFail(false);
                throw exc;
            }
            if (o == null) {
                throw new Exception("\u670d\u52a1\u5668\u5f02\u5e38");
            }
            JSONObject json = this.getOneDegreeJson(o);
            if ("ok".equalsIgnoreCase(json.getString("status"))) {
                Long credits = json.getLong("credits");
                orderNum = message.getRelationId();
                ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
                if (credits != null && credits >= 0L) {
                    this.remoteConsumerService.updateCredits(order.getConsumerId(), credits);
                }
                if (StringUtils.isBlank((CharSequence)(bizId = json.getString("bizId")))) {
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5f00\u53d1\u8005\u670d\u52a1\u5668\u54cd\u5e94\u5f00\u53d1\u8ba2\u5355\u53f7\u4e3a\u7a7a");
                    exc.setUrl(message.getHttpUrl());
                    exc.setDevRespone(message.getMessage());
                    exc.setFailType(3);
                    exc.setInterfaceType(1);
                    exc.setNormalFail(false);
                    throw exc;
                }
                try {
                    DubboResult bo = this.remoteIdempotentService.createIdempotent(IdempotentTypeEnums.ACTIVITY, bizId + "-" + order.getAppId(), 2592000);
                    if (!bo.isSuccess()) {
                        throw new Exception("\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u91cd\u590d");
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.error("\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u91cd\u590d\uff0cAPP=" + message.getAppId(), (Throwable)e);
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u4e0d\u80fd\u91cd\u590d");
                    exc.setUrl(message.getHttpUrl());
                    exc.setDevRespone(message.getMessage());
                    exc.setFailType(2);
                    exc.setInterfaceType(1);
                    exc.setNormalFail(false);
                    throw exc;
                }
            }
            DeveloperConsumeFailedException dcf = new DeveloperConsumeFailedException("", json.getString("errorMessage"));
            dcf.setNormalFail(true);
            throw dcf;
        }
        this.remoteActivityOrderService.updateDeveloperBizId(orderNum, bizId);
    }

    private JSONObject getOneDegreeJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (String key : o.keySet()) {
            if (o.get((Object)key) instanceof JSONObject) {
                JSONObject json2 = (JSONObject)o.get((Object)key);
                for (String key2 : json2.keySet()) {
                    json.put(key2, json2.get((Object)key2));
                }
                continue;
            }
            json.put(key, o.get((Object)key));
        }
        return json;
    }
}

