/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingHdtoolNewService;
import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.javatuples.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteOperatingHdtoolNewServiceImpl
implements RemoteOperatingHdtoolNewService {
    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private DuibaHdtoolOptionsService duibaHdtoolOptionsService;
    @Resource
    private OperatingActivityOptionsService operatingActivityOptionsService;
    @Autowired
    private ConsumerActivityLimitService consumerActivityLimitService;

    public DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexValid(Long operatingActivityId, Long appId) {
        try {
            OperatingActivityDto opertingActivity = this.operatingActivityService.find(operatingActivityId);
            if (null == opertingActivity || opertingActivity.getDeleted().booleanValue()) {
                return DubboResult.failResult((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u6d3b\u52a8\u4e0d\u53ef\u7528");
            }
            if (!opertingActivity.getAppId().equals(appId)) {
                return DubboResult.failResult((String)"\u65e0\u6743\u9650\u53c2\u4e0e\u6d3b\u52a8");
            }
            DuibaHdtoolDto duibaHdtool = null;
            if (opertingActivity.getActivityId() != null && OperatingActivityDto.isHdTool((Integer)opertingActivity.getType()) && (null == (duibaHdtool = this.duibaHdtoolService.find(opertingActivity.getActivityId())) || duibaHdtool.getStatus() != 1 || duibaHdtool.getDeleted().booleanValue())) {
                return DubboResult.failResult((String)"\u5151\u5427\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u6d3b\u52a8\u4e0d\u53ef\u7528");
            }
            return DubboResult.successResult((Object)Pair.with((Object)opertingActivity, duibaHdtool));
        }
        catch (Exception e) {
            return DubboResult.failResult((String)"\u65e0\u6743\u9650\u53c2\u4e0e\u6d3b\u52a8");
        }
    }

    public DubboResult<List<HdtoolOptionsDto>> findHdtoolOptions(OperatingActivityDto operatingActivityDO) {
        try {
            ArrayList<HdtoolOptionsDto> options = new ArrayList<HdtoolOptionsDto>();
            if (operatingActivityDO.getActivityId() != null && OperatingActivityDto.isHdTool((Integer)operatingActivityDO.getType())) {
                List<DuibaHdtoolOptionsDto> duibaOptions = this.duibaHdtoolOptionsService.findOptionsByDuibaHdtoolId(operatingActivityDO.getActivityId());
                for (DuibaHdtoolOptionsDto option : duibaOptions) {
                    HdtoolOptionsDto vo = new HdtoolOptionsDto();
                    vo.setId(option.getId());
                    vo.setDuibaHdtoolId(option.getDuibaHdtoolId());
                    vo.setName(option.getName());
                    vo.setPayload(option.getPayload());
                    vo.setAppItemId(option.getAppItemId());
                    vo.setItemId(option.getItemId());
                    vo.setPrizeType(option.getPrizeType());
                    vo.setFacePrice(option.getFacePrice());
                    vo.setLogo(option.getLogo());
                    vo.setRemaining(option.getRemaining());
                    vo.setRate(option.getRate());
                    vo.setHidden(option.getHidden());
                    vo.setDescription(option.getDescription());
                    vo.setLimitCount(option.getLimitCount());
                    vo.setMinComein(option.getMinComein());
                    vo.setDeleted(option.getDeleted());
                    vo.setGmtCreate(option.getGmtCreate());
                    vo.setGmtModified(option.getGmtModified());
                    options.add(vo);
                }
            } else {
                List<OperatingActivityOptionsDto> appOptions = this.operatingActivityOptionsService.findByOperatingActivityId(operatingActivityDO.getId());
                for (OperatingActivityOptionsDto option : appOptions) {
                    HdtoolOptionsDto vo = new HdtoolOptionsDto();
                    vo.setId(option.getId());
                    vo.setOperatingActivityId(option.getOperatingActivityId());
                    vo.setName(option.getName());
                    vo.setPayload(option.getPayload());
                    vo.setAppItemId(option.getAppItemId());
                    vo.setItemId(option.getItemId());
                    vo.setPrizeType(option.getPrizeType());
                    vo.setFacePrice(option.getFacePrice());
                    vo.setLogo(option.getLogo());
                    vo.setRemaining(option.getRemaining());
                    vo.setRate(option.getRate());
                    vo.setHidden(option.getHidden());
                    vo.setDescription(option.getDescription());
                    vo.setLimitCount(option.getLimitCount());
                    vo.setMinComein(option.getMinComein());
                    vo.setDeleted(option.getDeleted());
                    vo.setGmtCreate(option.getGmtCreate());
                    vo.setGmtModified(option.getGmtModified());
                    options.add(vo);
                }
            }
            return DubboResult.successResult(options);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)"error");
        }
    }

    public DubboResult<Integer> getLimitCountNum(Long consumerId, OperatingActivityDto operatingActivityDO, DuibaHdtoolDto duibaHdtool) {
        try {
            Integer limitCount = null;
            String limitScope = null;
            if (operatingActivityDO != null && duibaHdtool == null) {
                limitCount = operatingActivityDO.getLimitCount();
                limitScope = operatingActivityDO.getLimitScope();
            } else if (duibaHdtool != null) {
                limitCount = duibaHdtool.getLimitCount();
                limitScope = duibaHdtool.getLimitScope();
            }
            Integer num = null;
            if (limitCount != null && limitCount > 0 && (num = limitScope.equals("everyday") ? this.consumerActivityLimitService.findConsumerJoinNumToday(consumerId, operatingActivityDO.getId()) : this.consumerActivityLimitService.findConsumerJoinNumForever(consumerId, operatingActivityDO.getId())) != null) {
                if (num > limitCount) {
                    return DubboResult.successResult((Object)0);
                }
                num = limitCount - num;
            }
            return DubboResult.successResult(num);
        }
        catch (Exception e) {
            return DubboResult.successResult((Object)0);
        }
    }

    public DubboResult<Integer> getFreeLimitNum(Long consumerId, OperatingActivityDto operatingActivityDO, DuibaHdtoolDto duibaHdtool) {
        try {
            Integer freeLimit = null;
            String limitScope = null;
            if (operatingActivityDO != null && duibaHdtool == null) {
                freeLimit = operatingActivityDO.getFreeLimit();
                limitScope = operatingActivityDO.getFreeScope();
            } else if (duibaHdtool != null) {
                freeLimit = duibaHdtool.getFreeLimit();
                limitScope = duibaHdtool.getFreeScope();
            }
            Integer num = 0;
            if (freeLimit != null && freeLimit > 0 && (num = limitScope.equals("everyday") ? this.consumerActivityLimitService.findConsumerFreeNumToday(consumerId, operatingActivityDO.getId()) : this.consumerActivityLimitService.findConsumerFreeNumForever(consumerId, operatingActivityDO.getId())) != null) {
                if (num > freeLimit) {
                    return DubboResult.successResult((Object)0);
                }
                num = freeLimit - num;
            }
            return DubboResult.successResult((Object)num);
        }
        catch (Exception e) {
            return DubboResult.successResult((Object)0);
        }
    }
}

