/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterStatisticDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityListDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecenter.RemoteGameCenterBackendService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterResourceService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGameCenterBackendService")
public class RemoteGameCenterBackendServiceImpl
implements RemoteGameCenterBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteGameCenterBackendServiceImpl.class);
    @Autowired
    private GameCenterResourceService gameCenterResourceService;

    public DubboResult<GameCenterStatisticDto> findStatistic() {
        try {
            GameCenterStatisticDto gameCenterStatisticDto = this.gameCenterResourceService.findStatistic();
            return DubboResult.successResult((Object)gameCenterStatisticDto);
        }
        catch (GameCenterException e) {
            log.error("findStatistic failed.", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<LittleGameResourceListDto> findLittleGameResource(Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = this.gameCenterResourceService.findLittleGameResource(offset, max);
        return DubboResult.successResult((Object)littleGameResourceListDto);
    }

    public DubboResult<Boolean> updateResourceLocation(Long activityId, Integer activityType, List<String> addLocationNames, List<String> delLocationNames) {
        try {
            Boolean result = this.gameCenterResourceService.updateResourceLocation(activityId, activityType, addLocationNames, delLocationNames);
            return DubboResult.successResult((Object)result);
        }
        catch (GameCenterException e) {
            log.error("updateResourceLocation failed. activityId={}, activityType={}, addLocationNames={}, delLocationNames={}", new Object[]{activityId, activityType, addLocationNames, delLocationNames, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<RelatedActivityListDto> findRelatedActivity(Integer offset, Integer max) {
        try {
            RelatedActivityListDto relatedActivityListDto = this.gameCenterResourceService.findRelatedActivity(offset, max);
            return DubboResult.successResult((Object)relatedActivityListDto);
        }
        catch (GameCenterException e) {
            log.error("findRelatedActivity failed. offset={}, max={}", new Object[]{offset, max, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> addRelatedActivity(Long activityId, Integer activityType) {
        try {
            Boolean result = this.gameCenterResourceService.addRelatedActivity(activityId, activityType);
            return DubboResult.successResult((Object)result);
        }
        catch (GameCenterException e) {
            log.error("findRelatedActivity failed. activityId={}, activityType={}", new Object[]{activityId, activityType, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteRelatedActivity(Long activityId, Integer activityType) {
        Boolean result = this.gameCenterResourceService.deleteRelatedActivity(activityId, activityType);
        return DubboResult.successResult((Object)result);
    }

    public DubboResult<LittleGameResourceListDto> findAvailableLittleGameByAppId(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = this.gameCenterResourceService.findAvailableLittleGameByAppId(appId, offset, max, false);
        return DubboResult.successResult((Object)littleGameResourceListDto);
    }

    public DubboResult<LittleGameResourceListDto> findHiddenLittleGameByAppId(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = this.gameCenterResourceService.findHiddenLittleGameByAppId(appId, offset, max);
        return DubboResult.successResult((Object)littleGameResourceListDto);
    }
}

