/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecenter.RemoteGameCenterService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterResourceService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGameCenterService")
public class RemoteGameCenterServiceImpl
implements RemoteGameCenterService {
    private static final Logger log = LoggerFactory.getLogger(RemoteGameCenterServiceImpl.class);
    @Autowired
    private GameCenterHomeService gameCenterHomeService;
    @Autowired
    private GameCenterResourceService gameCenterResourceService;

    public DubboResult<GameCenterHomeResourceListDto> findResourceByLocationAndAppId(String locationName, Long appId, Integer offset, Integer max) {
        try {
            GameCenterHomeResourceListDto gameCenterHomeResourceListDto = this.gameCenterHomeService.findResourceByLocationAndAppId(locationName, appId, offset, max);
            return DubboResult.successResult((Object)gameCenterHomeResourceListDto);
        }
        catch (Exception e) {
            log.error("findResourceByLocationAndAppId failed. locationName={}, appId={}, offset={}, max={}", new Object[]{locationName, appId, offset, max, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<LittleGameResourceListDto> findGameForHomeFloor(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = this.gameCenterResourceService.findAvailableLittleGameByAppId(appId, offset, max, true);
        return DubboResult.successResult((Object)littleGameResourceListDto);
    }
}

