/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.plugin;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.remoteservice.plugin.RemoteActivityPluginService;
import cn.com.duiba.activity.center.biz.service.activity_brick.PopupActivityBrickService;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import net.rubyeye.xmemcached.GetsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteActivityPluginServiceImpl
implements RemoteActivityPluginService {
    private static Logger log = LoggerFactory.getLogger(RemoteActivityPluginServiceImpl.class);
    @Resource
    private ActivityPluginService activityPluginService;
    @Resource
    private PopupActivityBrickService popupActivityBrickService;
    @Autowired
    private XMemCacheClient xMemCacheClient;

    public DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList() {
        List<ActivityPluginDto> dto;
        String key = "ACTIVITY_PLUGIN_TIME_60";
        try {
            GetsResponse last = this.xMemCacheClient.getMemcachedClient().gets(key);
            if (last == null) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("status", 1);
                dto = this.activityPluginService.findActivityPluginInfoList(paramMap);
                this.xMemCacheClient.getMemcachedClient().add(key, 60, dto);
            } else {
                dto = (List<ActivityPluginDto>)last.getValue();
            }
        }
        catch (Exception e) {
            log.error("xMemCacheClient \u4e2d\u83b7\u53d6 \u63d2\u4ef6\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25  \u964d\u7ea7\u4e3a\u4ece \u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u6570\u636e", (Throwable)e);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("status", 1);
            dto = this.activityPluginService.findActivityPluginInfoList(paramMap);
        }
        return DubboResult.successResult((Object)dto);
    }

    public DubboResult<PopupActivityBrickDto> findBrickById(Long id) {
        return DubboResult.successResult((Object)this.popupActivityBrickService.findById(id));
    }

    public DubboResult<ActivityPluginDto> findById(Long id) {
        return DubboResult.successResult((Object)this.activityPluginService.findById(id));
    }

    public DubboResult<String> createOrder(Long consumerId, String transfer, String ip, String description, String ua, String os, ActivityPluginDto pluDto) {
        try {
            String orderNum = this.activityPluginService.createOrder(consumerId, transfer, ip, description, ua, os, pluDto);
            return DubboResult.successResult((Object)orderNum);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u751f\u6210\u5931\u8d25", (Throwable)e);
            if (e instanceof StatusException) {
                return DubboResult.failResult((String)((StatusException)e).getMessage());
            }
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateStatus(Long id, Integer value) {
        return DubboResult.successResult((Object)this.activityPluginService.OpenStatus(id, value));
    }
}

