/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCommands;

@Service
public class ActivityShieldServiceImpl
implements ActivityShieldService {
    @Resource
    private ActivityShieldDao gameCenterShieldDao;
    @Autowired
    private JedisCommands jedisCommands;

    @Override
    public ShieldItemDto find(Long id) {
        ActivityShieldEntity activityShieldEntity = this.gameCenterShieldDao.find(id);
        return (ShieldItemDto)BeanUtils.copy((Object)activityShieldEntity, ShieldItemDto.class);
    }

    @Override
    public List<ShieldItemDto> findShieldList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(this.gameCenterShieldDao.findShieldList(paramMap), ShieldItemDto.class);
    }

    @Override
    public Integer countShield(Map<String, Object> paramMap) {
        return this.gameCenterShieldDao.countShield(paramMap);
    }

    @Override
    public boolean isExist(Long appId, Integer activityType, Long activityId) {
        String key = "activity.center.gamecenter.shield." + String.valueOf(appId) + "." + String.valueOf(activityType) + "." + String.valueOf(activityId);
        String resultStr = this.getCache(key);
        if (StringUtils.isNotEmpty((String)resultStr)) {
            return Boolean.valueOf(resultStr);
        }
        ActivityShieldEntity activityShieldEntity = this.gameCenterShieldDao.findShield(appId, activityType, activityId);
        boolean result = activityShieldEntity != null;
        this.putCache(key, String.valueOf(result));
        return result;
    }

    @Override
    public Long addShield(ShieldItemDto shieldItemDto) {
        return this.gameCenterShieldDao.insert((ActivityShieldEntity)BeanUtils.copy((Object)shieldItemDto, ActivityShieldEntity.class));
    }

    @Override
    public Boolean removeShield(Long shieldId) {
        return this.gameCenterShieldDao.delete(shieldId) == 1;
    }

    private String getCache(String key) {
        return this.jedisCommands.get(key);
    }

    private void putCache(String key, String value) {
        this.jedisCommands.set(key, value, "NX", "EX", 60L);
    }

    @Override
    public List<ActivityShieldEntity> findShields(Long appId, Integer activityType, Set<Long> activityIds, boolean useCache) {
        if (useCache) {
            String key = this.buildKey(appId, activityType, activityIds);
            String entityListStr = this.getCache(key);
            if (StringUtils.isNotEmpty((String)entityListStr)) {
                return JSON.parseArray((String)entityListStr, ActivityShieldEntity.class);
            }
            List<ActivityShieldEntity> activityShieldEntityies = this.gameCenterShieldDao.findShields(appId, activityType, activityIds);
            this.putCache(key, JSON.toJSONString(activityShieldEntityies));
            if (CollectionUtils.isEmpty(activityShieldEntityies)) {
                return Collections.emptyList();
            }
            return activityShieldEntityies;
        }
        return this.gameCenterShieldDao.findShields(appId, activityType, activityIds);
    }

    private String buildKey(Long appId, Integer activityType, Set<Long> activityIds) {
        ArrayList<Long> activityIdList = new ArrayList<Long>(activityIds);
        Collections.sort(activityIdList);
        StringBuilder keyBuilder = new StringBuilder("activity.center.gamecenter.shields.").append(appId).append('.').append(activityType).append('.');
        for (Long activityId : activityIdList) {
            keyBuilder.append(activityId).append('.');
        }
        return keyBuilder.substring(0, keyBuilder.length() - 1);
    }
}

