/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.Utils;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCommands;

@Service
class GameCenterCommonSerice {
    private static final Logger log = LoggerFactory.getLogger(GameCenterCommonSerice.class);
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private DeveloperActBlackService developerActBlackService;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    @Autowired
    private ActivityShieldService gameCenterShieldService;
    @Autowired
    private GameCenterResourceLocationDao gameCenterResourceLocationDao;
    @Autowired
    private LittleGameService littleGameService;
    @Autowired
    private JedisCommands jedisCommands;

    GameCenterCommonSerice() {
    }

    public Long findDeveloperIdByAppId(Long appId) {
        String redisKey = "activity.center.gamecenter.appdo.did." + String.valueOf(appId);
        String didStr = this.getCache(redisKey);
        if (StringUtils.isNotEmpty((String)didStr)) {
            return Long.parseLong(didStr);
        }
        AppDO appDO = this.remoteAppService.find(appId);
        if (appDO == null) {
            log.error("appId is invalid: no record found: {}", (Object)appId);
            return null;
        }
        Long did = appDO.getDeveloperId();
        this.putCache(redisKey, String.valueOf(did));
        return did;
    }

    public boolean filterByActivityBlacklist(LittleGameEntity littleGameEntity, Long developerId) {
        return littleGameEntity.isOpenSwitch(1) && this.developerActBlackService.isExist(littleGameEntity.getId(), 47, developerId) != false;
    }

    public boolean filterBySpecify(LittleGameEntity littleGameEntity, Long appId) {
        if (!littleGameEntity.isOpenSwitch(0)) {
            return false;
        }
        String key = "activity.center.gamecenter.appspecify.littlegame." + String.valueOf(littleGameEntity.getId()) + "." + String.valueOf(appId);
        String resultStr = this.getCache(key);
        if (StringUtils.isNotEmpty((String)resultStr)) {
            return Boolean.valueOf(resultStr);
        }
        boolean result = this.duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(littleGameEntity.getId(), appId, "littlegame") == null;
        this.putCache(key, String.valueOf(result));
        return result;
    }

    public boolean filterByShield(Long appId, Long littleGameId) {
        return this.gameCenterShieldService.isExist(appId, 47, littleGameId);
    }

    public Long findLocationIdByName(String name) throws GameCenterException {
        String key = "activity.center.gamecenter.locname." + name;
        String resultStr = this.getCache(key);
        if (StringUtils.isNotEmpty((String)resultStr)) {
            return Long.valueOf(resultStr);
        }
        GameCenterResourceLocationEntity entity = this.gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found:" + name);
        }
        Long result = entity.getId();
        this.putCache(key, String.valueOf(result));
        return result;
    }

    public Map<Long, LittleGameEntity> buildLittleGameEntityMap(Set<Long> littleGameIds) {
        List<LittleGameEntity> littleGameEntities = this.littleGameService.selectByIds(littleGameIds);
        if (CollectionUtils.isEmpty(littleGameEntities)) {
            return Collections.emptyMap();
        }
        HashMap<Long, LittleGameEntity> map = new HashMap<Long, LittleGameEntity>();
        for (LittleGameEntity entity : littleGameEntities) {
            map.put(entity.getId(), entity);
        }
        return map;
    }

    public Map<Long, ActivityShieldEntity> buildActivityShieldEntityMap(Long appId, Set<Long> littleGameIds, boolean useCache) {
        List<ActivityShieldEntity> activityShieldEntityList = this.gameCenterShieldService.findShields(appId, 47, littleGameIds, useCache);
        if (CollectionUtils.isEmpty(activityShieldEntityList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, ActivityShieldEntity> map = new HashMap<Long, ActivityShieldEntity>();
        for (ActivityShieldEntity entity : activityShieldEntityList) {
            map.put(entity.getActivityId(), entity);
        }
        return map;
    }

    public List<LittleGameResourceDto> batchFindAvailableLittleGames(List<LittleGameResourceDto> littleGameResourceDtoList, Set<Long> littleGameIds, Long appId, Long developerId, boolean needCheckShield, boolean shieldUseCache) {
        Map<Long, LittleGameEntity> littleGameEntityMap = this.buildLittleGameEntityMap(littleGameIds);
        if (littleGameEntityMap.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, ActivityShieldEntity> activityShieldEntityMap = null;
        if (needCheckShield) {
            activityShieldEntityMap = this.buildActivityShieldEntityMap(appId, littleGameIds, shieldUseCache);
        }
        ArrayList<LittleGameResourceDto> finalLittleGameResourceDtoList = new ArrayList<LittleGameResourceDto>();
        for (LittleGameResourceDto littleGameResourceDto : littleGameResourceDtoList) {
            LittleGameEntity littleGameEntity = littleGameEntityMap.get(littleGameResourceDto.getActivityId());
            if (Utils.filterLittleGameByStatus(littleGameEntity) || this.filterByActivityBlacklist(littleGameEntity, developerId) || this.filterBySpecify(littleGameEntity, appId) || MapUtils.isNotEmpty(activityShieldEntityMap) && null != activityShieldEntityMap.get(littleGameResourceDto.getActivityId())) continue;
            littleGameResourceDto.setTitle(littleGameEntity.getLittleGameTitle());
            littleGameResourceDto.setBannerImg(littleGameEntity.getLittleGameBannerImg());
            littleGameResourceDto.setIconImg(littleGameEntity.getLittleGameIconImg());
            littleGameResourceDto.setSmallImg(littleGameEntity.getLittleGameSmallImg());
            littleGameResourceDto.setRecomImg(littleGameEntity.getLittleGameRecomImg());
            finalLittleGameResourceDtoList.add(littleGameResourceDto);
        }
        return finalLittleGameResourceDtoList;
    }

    private String getCache(String key) {
        return this.jedisCommands.get(key);
    }

    private void putCache(String key, String value) {
        this.jedisCommands.set(key, value, "NX", "EX", 60L);
    }
}

