/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.GameCenterCommonSerice;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameCenterHomeServiceImpl
implements GameCenterHomeService {
    @Autowired
    private GameCenterResourceDao gameCenterResourceDao;
    @Autowired
    private GameCenterCommonSerice gameCenterCommonSerice;

    @Override
    public GameCenterHomeResourceListDto findResourceByLocationAndAppId(String locationName, Long appId, Integer offset, Integer max) throws GameCenterException {
        GameCenterHomeResourceListDto gameCenterHomeResourceListDto = new GameCenterHomeResourceListDto();
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByLocationId(this.gameCenterCommonSerice.findLocationIdByName(locationName));
        if (CollectionUtils.isEmpty(entities)) {
            return gameCenterHomeResourceListDto;
        }
        ArrayList<GameCenterHomeResourceDto> gameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        Long developerId = this.gameCenterCommonSerice.findDeveloperIdByAppId(appId);
        if (developerId == null) {
            return gameCenterHomeResourceListDto;
        }
        HashSet<Long> littleGameIds = new HashSet<Long>();
        for (GameCenterResourceEntity gameCenterResourceEntity : entities) {
            if (gameCenterResourceEntity.getActivityType() != 47) continue;
            littleGameIds.add(gameCenterResourceEntity.getActivityId());
            GameCenterHomeResourceDto temp = new GameCenterHomeResourceDto();
            temp.setActivityId(gameCenterResourceEntity.getActivityId());
            temp.setActivityType(gameCenterResourceEntity.getActivityType());
            temp.setGmtCreate(gameCenterResourceEntity.getGmtCreate());
            temp.setGmtModified(gameCenterResourceEntity.getGmtModified());
            temp.setLocationId(gameCenterResourceEntity.getResourceLocationId());
            temp.setInfoType("25");
            temp.setInfo(gameCenterResourceEntity.getActivityId());
            temp.setLink("/littleGame/start?littleGameId=" + String.valueOf(gameCenterResourceEntity.getActivityId()) + "&startSource=null&dbnewopen");
            gameCenterHomeResourceDtoList.add(temp);
        }
        Map<Long, LittleGameEntity> littleGameEntityMap = this.gameCenterCommonSerice.buildLittleGameEntityMap(littleGameIds);
        if (littleGameEntityMap.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }
        Map<Long, ActivityShieldEntity> activityShieldEntityMap = this.gameCenterCommonSerice.buildActivityShieldEntityMap(appId, littleGameIds, true);
        ArrayList<GameCenterHomeResourceDto> finalGameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        for (GameCenterHomeResourceDto item : gameCenterHomeResourceDtoList) {
            LittleGameEntity littleGameEntity = littleGameEntityMap.get(item.getActivityId());
            if (Utils.filterLittleGameByStatus(littleGameEntity) || this.gameCenterCommonSerice.filterByActivityBlacklist(littleGameEntity, developerId) || this.gameCenterCommonSerice.filterBySpecify(littleGameEntity, appId) || null != activityShieldEntityMap.get(item.getActivityId())) continue;
            item.setTitle(littleGameEntity.getLittleGameTitle());
            item.setDescription(littleGameEntity.getLittleGameRecomDescribe());
            item.setBannerImg(littleGameEntity.getLittleGameBannerImg());
            item.setRecommendImg(littleGameEntity.getLittleGameSmallImg());
            item.setIconImg(littleGameEntity.getLittleGameIconImg());
            finalGameCenterHomeResourceDtoList.add(item);
        }
        if (finalGameCenterHomeResourceDtoList.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }
        Collections.sort(finalGameCenterHomeResourceDtoList, new Comparator<GameCenterHomeResourceDto>(){

            @Override
            public int compare(GameCenterHomeResourceDto o1, GameCenterHomeResourceDto o2) {
                return o2.getGmtModified().compareTo(o1.getGmtModified());
            }
        });
        gameCenterHomeResourceListDto.setCount(Integer.valueOf(finalGameCenterHomeResourceDtoList.size()));
        gameCenterHomeResourceListDto.setGameCenterHomeResourceDtoList(Utils.subList(finalGameCenterHomeResourceDtoList, offset, max));
        return gameCenterHomeResourceListDto;
    }
}

