/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gameskin.impl;

import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.activity.center.biz.dao.gameskin.GameSkinDao;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;
import cn.com.duiba.activity.center.biz.service.gameskin.GameSkinService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class GameSkinServiceImpl
implements GameSkinService {
    @Resource
    private GameSkinDao gameSkinDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public GameSkinEntity selectById(Long id) {
        return this.gameSkinDao.selectById(id);
    }

    @Override
    public Long insert(GameSkinEntity entity) {
        return this.gameSkinDao.insert(entity);
    }

    @Override
    public Long update(GameSkinEntity entity) {
        if (entity.getId() != null && entity.getDom() != null) {
            this.cacheClient.remove(this.getContentCacheKeyById(entity.getId()));
        }
        return this.gameSkinDao.update(entity);
    }

    @Override
    public List<GameSkinEntity> selectByPage(int offset, int max, List<Byte> types) {
        return this.gameSkinDao.selectByPage(offset, max, types);
    }

    @Override
    public Long selectCount(String name, List<Byte> types) {
        return this.gameSkinDao.selectCount(name, types);
    }

    @Override
    public List<GameSkinEntity> selectByType(Byte type) {
        return this.gameSkinDao.selectByType(type);
    }

    @Override
    public String getBrickContentById(final Long id) {
        return (String)this.cacheClient.getWithCacheLoader(this.getContentCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return GameSkinServiceImpl.this.gameSkinDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKeyById(Long id) {
        return "activity-littleGameBrickNoContentById_" + id;
    }

    private String getContentCacheKeyById(Long id) {
        return "activity-littleGameBrickContentById_" + id;
    }

    @Override
    public GameSkinDto findNoContent(final Long id) {
        return (GameSkinDto)this.cacheClient.getWithCacheLoader(this.getNoContentCacheKeyById(id), 20, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<GameSkinDto>(){

            public GameSkinDto load() {
                return (GameSkinDto)BeanUtils.copy((Object)GameSkinServiceImpl.this.gameSkinDao.findNoContent(id), GameSkinDto.class);
            }
        });
    }
}

