/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.impl;

import cn.com.duiba.activity.center.biz.service.GoodsService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteCouponFlowService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsServiceImpl
implements GoodsService {
    @Autowired
    private RemoteCouponFlowService remoteCouponFlowService;
    @Autowired
    private RemoteGoodsCouponService remoteGoodsCouponService;

    @Override
    public boolean isGoodsCoupon(ItemKey itemKey) {
        if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(16)) {
            return true;
        }
        return itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(16);
    }

    @Override
    public CouponDO getOneCoupon(ItemKey itemKey, Long consumerId, String bizNum) throws Exception {
        if (this.isGoodsCoupon(itemKey)) {
            return this.getOneGoodsCoupon(itemKey, consumerId, bizNum);
        }
        return this.remoteCouponFlowService.getOneCoupon(itemKey);
    }

    @Override
    public void returnOneCoupon(long couponId, ItemKey itemKey, String bizNum) throws Exception {
        if (this.isGoodsCoupon(itemKey)) {
            DubboResult ret = this.remoteGoodsCouponService.rollbackCoupon(Long.valueOf(couponId), bizNum);
            if (!((Boolean)ret.getResult()).booleanValue()) {
                throw new Exception("\u8fd4\u56de\u4f18\u60e0\u5238\u5931\u8d25");
            }
        } else {
            this.remoteCouponFlowService.returnOneCoupon(couponId);
        }
    }

    private CouponDO getOneGoodsCoupon(ItemKey itemKey, Long consumerId, String bizNum) throws Exception {
        DubboResult ret = null;
        Integer subType = null;
        Long itemId = null;
        Long appItemId = null;
        if (itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(16)) {
            subType = itemKey.getItem().getSubType();
            itemId = itemKey.getItem().getId();
            ret = this.remoteGoodsCouponService.takeCoupon(GoodsTypeEnum.DUIBA, itemId.longValue(), consumerId.longValue(), bizNum);
        } else if (itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(16)) {
            subType = itemKey.getAppItem().getSubType();
            appItemId = itemKey.getAppItem().getId();
            ret = this.remoteGoodsCouponService.takeCoupon(GoodsTypeEnum.APP, appItemId.longValue(), consumerId.longValue(), bizNum);
        }
        if (!ret.isSuccess()) {
            throw new Exception("\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6\u4f18\u60e0\u5238\u5931\u8d25!");
        }
        if (ret.getResult() == null) {
            throw new StatusException(0, "\u5151\u6362\u5238\u5df2\u5151\u5b8c!");
        }
        GoodsCouponDto dto = (GoodsCouponDto)ret.getResult();
        CouponDO coupon = new CouponDO();
        coupon.setId(dto.getGoodsCouponId());
        coupon.setBatchId(dto.getGoodsBatchId());
        if (subType == 0) {
            coupon.setCode(dto.getCode());
            coupon.setPassword(dto.getPassword());
        } else if (subType == 2) {
            coupon.setCode(dto.getCode());
            coupon.setPassword(dto.getPassword());
        } else if (subType == 1) {
            coupon.setCode(dto.getLink());
            coupon.setPassword(dto.getLink());
        }
        coupon.setAppItemId(appItemId);
        coupon.setItemId(itemId);
        return coupon;
    }
}

