/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.notify.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.service.hdtool.CreditsHdtoolOrdersService;
import cn.com.duiba.activity.center.biz.service.notify.NotifyQueueameService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class NotifyQueueameServiceImpl
implements NotifyQueueameService {
    private static Logger log = LoggerFactory.getLogger(NotifyQueueameServiceImpl.class);
    @Autowired
    @Qualifier(value="notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Resource
    private CreditsHdtoolOrdersService creditsHdtoolOrdersService;
    @Resource
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;

    @Override
    public void insertHdtoolOrderNotifyQueueIfNesscery(Long consumerId, Long hdtoolOrderId) {
        try {
            HdtoolOrdersDto hdtoolOrder = this.creditsHdtoolOrdersService.find(consumerId, hdtoolOrderId);
            if (hdtoolOrder.getCredits() <= 0L) {
                return;
            }
            if (hdtoolOrder.getStatus() != 1 && hdtoolOrder.getStatus() != 2) {
                return;
            }
            ConsumerDO consumer = this.remoteConsumerService.find(hdtoolOrder.getConsumerId());
            NotifyQueueDO nq = new NotifyQueueDO();
            nq.setAppId(hdtoolOrder.getAppId());
            nq.setConsumerId(hdtoolOrder.getConsumerId());
            nq.setDeveloperBizId(hdtoolOrder.getDeveloperBizId());
            nq.setDuibaOrderNum(HdtoolOrdersDto.generateOrderNum((Long)hdtoolOrderId));
            if (hdtoolOrder.getError4Developer() != null) {
                nq.setError4developer(hdtoolOrder.getError4Developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(hdtoolOrderId);
            nq.setRelationType("hdtool");
            nq.setResult(Boolean.valueOf(1 == hdtoolOrder.getStatus()));
            nq.setTimes(Integer.valueOf(0));
            this.notifyQueueDAO.insert(nq);
            this.notifyCenterServiceClient.notifyImmediately(nq.getId());
        }
        catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error", (Throwable)e);
        }
    }
}

