/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.plugin.impl;

import cn.com.duiba.activity.center.api.dto.other.DuibaRemainingMoneyDO;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.entity.plugin.ActivityPluginVistEntity;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagCallback;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginVistService;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.dcommons.flowwork.ActivityPluginFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.CenterConfigDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteCenterConfigService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginFlowInnerServiceImpl
implements PluginFlowInnerService {
    private static Logger log = LoggerFactory.getLogger(PluginFlowInnerServiceImpl.class);
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteCenterConfigService remoteCenterConfigService;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private LuckBagCallback.LuckBagFlowWorker luckBagFlowWorker;
    @Autowired
    private ActivityPluginFlowworkService activityPluginFlowworkService;
    @Autowired
    private ActivityPluginVistService activityPluginVistService;
    @Autowired
    private ConsumerActivityLimitService consumerActivityLimitService;

    @Override
    public ActivityPrizeOptionDto randomPrize(Long activityId, String activityType, List<ActivityPrizeOptionDto> options) {
        double totalRate = 0.0;
        ArrayList validOptions = Lists.newArrayList();
        for (ActivityPrizeOptionDto option : options) {
            if ("lucky".equals(option.getPrizeType()) || !StringUtils.isNotBlank((CharSequence)option.getRate()) || !(Double.valueOf(option.getRate()) > 1.0E-5)) continue;
            totalRate += Double.valueOf(option.getRate()).doubleValue();
            validOptions.add(option);
        }
        if (totalRate > 100.0) {
            LogUtil.logPluginKan((String)("\u5956\u9879\u6982\u7387\u548c\u8d85\u8fc7100%,duibaActivityId=" + activityId + ",activityType=" + activityType));
            return this.awardOptionLuck(activityId, activityType, options);
        }
        if (options.size() > 1) {
            Collections.shuffle(options);
        }
        double randomNumber = Math.random() * 100.0;
        double temp = 0.0;
        ActivityPrizeOptionDto winOption = null;
        for (ActivityPrizeOptionDto option : validOptions) {
            if (!(randomNumber <= (temp += Double.valueOf(option.getRate()).doubleValue()))) continue;
            winOption = option;
            break;
        }
        if (winOption == null) {
            LogUtil.logPluginKan((String)("\u51fa\u5956\u5f02\u5e38,duibaActivityId=" + activityId + ",activityType=" + activityType));
            return this.awardOptionLuck(activityId, activityType, options);
        }
        LogUtil.logPluginKan((String)("awardOptionLuck    =====>  \u4e2d\u5956" + activityId + ",activityType=" + winOption.getPrizeType()));
        return winOption;
    }

    @Override
    public ActivityPrizeOptionDto awardOptionLuck(Long activityId, String activityType, List<ActivityPrizeOptionDto> options) {
        ArrayList<ActivityPrizeOptionDto> lucks = new ArrayList<ActivityPrizeOptionDto>();
        for (ActivityPrizeOptionDto option : options) {
            if (!"lucky".equals(option.getPrizeType())) continue;
            lucks.add(option);
        }
        if (lucks.size() < 1) {
            LogUtil.logPluginKan((String)("awardOptionLuck    =====>\u5956\u9879\u6ca1\u6709\u914d\u7f6e\u798f\u888b\uff0c\u51fa\u8c22\u8c22\u53c2\u4e0e" + activityId + ",activityType=" + activityType));
            return this.awardThanks(activityId, activityType);
        }
        Random random = new Random();
        int thanksIndex = Math.abs(random.nextInt()) % lucks.size();
        return (ActivityPrizeOptionDto)lucks.get(thanksIndex);
    }

    @Override
    public ActivityPrizeOptionDto awardThanks(Long activityId, String activityType) {
        ActivityPrizeOptionDto option = new ActivityPrizeOptionDto();
        option.setActivityId(activityId);
        option.setActivityType(activityType);
        option.setPrizeType(ActivityPrizeOptionDto.Prize_Type_Thanks);
        option.setPrizeName("\u8c22\u8c22\u53c2\u4e0e");
        return option;
    }

    @Override
    public ActivityPrizeOptionDto winOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options) {
        LogUtil.logPluginKan((String)("winOptionCheck  \u9a8c\u8bc1\u5f00\u59cb===>" + JSONObject.toJSONString((Object)winOption)));
        if ("lucky".equals(winOption.getPrizeType())) {
            return winOption;
        }
        boolean optionCheck = this.validOptionCheck(order, winOption);
        boolean itemCheck = this.validItemKeyCheck(order, winOption, optionCheck);
        if (!itemCheck) {
            LogUtil.logPluginKan((String)("winOptionCheck \u5546\u54c1\u672c\u8eab\u9a8c\u8bc1\u5931\u8d25 winOption===>" + JSONObject.toJSONString((Object)winOption)));
            if (winOption.getPrizeType().equals("lucky")) {
                winOption = this.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                LogUtil.logPluginKan((String)("winOptionCheck    =====>\u5546\u54c1\u964d\u7ea7\u4e3a  \u8c22\u8c22\u53c2\u4e0e" + JSONObject.toJSONString((Object)winOption)));
                return winOption;
            }
        } else {
            return winOption;
        }
        winOption = this.awardOptionLuck(order.getDuibaActivityId(), order.getActivityType(), options);
        LogUtil.logPluginKan((String)("winOptionCheck    =====>\u5546\u54c1\u964d\u7ea7\u4e3a  \u798f\u888b" + JSONObject.toJSONString((Object)winOption)));
        return winOption;
    }

    private boolean validOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto prize) {
        ActivityPluginVistEntity enty;
        if (prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            return true;
        }
        if (prize.getMinComein() != null && (enty = this.activityPluginVistService.findByActivityIdAndType(order.getDuibaActivityId(), 0)).getVisitTimes() < prize.getMinComein()) {
            LogUtil.logPluginKan((String)("\u4fdd\u5e95\u4eba\u6570\u6821\u9a8c  validOptionCheck    =====>\u53c2\u4e0e\u4eba\u6570\uff1a" + enty.getVisitTimes() + "\u5956\u9879\u914d\u7f6e\u4eba\u6570:" + prize.getMinComein()));
            return false;
        }
        Long stockId = prize.getStockId();
        DubboResult stockNum = this.remoteStockService.find(stockId.longValue());
        if (!stockNum.isSuccess() || null == stockNum.getResult() || (Long)stockNum.getResult() <= 0L) {
            return false;
        }
        Integer limintCount = this.consumerActivityLimitService.findConsumerWinOptionNum(order.getConsumerId(), order.getDuibaActivityId(), "plugin" + prize.getId());
        if (limintCount == null) {
            limintCount = 0;
        }
        if (prize.getWinLimit() != null && prize.getWinLimit() > 0 && prize.getWinLimit() <= limintCount) {
            LogUtil.logPluginKan((String)("\u7528\u6237\u4e2d\u5956\u9650\u5236  validOptionCheck    =====>prize.getWinLimit()\uff1a" + prize.getWinLimit() + ":\u53c2\u4e0e\u6b21\u6570\uff1a" + limintCount + "\u5956\u9879\uff1a" + prize.getId()));
            return false;
        }
        return true;
    }

    @Override
    public boolean validItemKeyCheck(ActivityOrderDto order, ActivityPrizeOptionDto prize, boolean check) {
        DuibaRemainingMoneyDO duibaM;
        Long money;
        if (!check) {
            return false;
        }
        if (prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            return true;
        }
        ItemKey itemKey = this.remoteItemKeyService.getItemKeyIncludeDeleted(prize.getItemId(), prize.getAppItemId(), order.getAppId());
        if (itemKey == null) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====>itemKey ==null");
            return false;
        }
        if (!"alipay".equals(itemKey.getItemType()) && !"phonebill".equals(itemKey.getItemType()) && !"qb".equals(itemKey.getItemType()) && itemKey.getAppItem() != null && itemKey.getAppItem().getDeleted().booleanValue()) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5f00\u53d1\u8005\u4ed3\u5e93\u5220\u9664\u9a8c\u8bc1(\u5f00\u53d1\u8005\u6d3b\u52a8\u8bdd\u8d39,QB,\u652f\u4ed8\u5b9d\u53ef\u80fd\u6ca1\u5728\u4ed6\u5e93\u91cc\u4e0d\u9a8c\u8bc1)");
            return false;
        }
        if (itemKey.getItem() != null && (!itemKey.getItem().getEnable().booleanValue() || itemKey.getItem().getDeleted().booleanValue())) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5151\u5427\u5546\u54c1\u7981\u7528\u6216\u5220\u9664");
            return false;
        }
        if (this.timeLimitService.isLimitItem(itemKey.getItem())) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u9650\u65f6\uff0c\u9650\u91cf\uff0c\u4f1a\u5458\u7b49\u7ea7\u9650\u5236\uff0c\u5151\u6362\u9650\u5236\uff0c\u65e5\u671f\u9650\u5236\u7b49\u6709\u9650\u5236\u7684\uff0c\u90fd\u4e0d\u4e2d\u5956");
            return false;
        }
        if (!itemKey.getApp().isAppSwitch(7)) {
            if (null != itemKey.getItem() && itemKey.getItem().getType().equals("coupon")) {
                if (!itemKey.getItem().getId().equals(191L)) {
                    LogUtil.logPluginKan((String)"validItemKeyCheck    =====> APP\u5151\u6362\u9650\u5236\u53ea\u80fd\u6d4b\u8bd5\u4e13\u7528\u5546\u54c1\u4e2d\u5956");
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((prize.getPrizeType().equals("object") || prize.getPrizeType().equals("coupon") || prize.getPrizeType().equals("virtual")) && this.itemKeyStockServcie.findRemaining(itemKey) <= 0) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5956\u9879\u603b\u5e93\u5b58\u9a8c\u8bc1");
            return false;
        }
        if (!this.itemKeyStockServcie.couponBatchCheck(itemKey)) {
            LogUtil.logPluginKan((String)("validItemKeyCheck    =====> \u4f18\u60e0\u5238\u6279\u6b21\u6821\u9a8c_" + JSONObject.toJSONString((Object)itemKey)));
            return false;
        }
        if (itemKey.getAppItem() != null && "expired".equals(itemKey.getAppItem())) {
            LogUtil.logPluginKan((String)("validItemKeyCheck    =====> \u5931\u6548\u9a8c\u8bc1_" + JSONObject.toJSONString((Object)itemKey)));
            return false;
        }
        if ("object".equals(itemKey.getItemType())) {
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5b9e\u7269\u81ea\u52a8\u4e0b\u67b6\u5931\u6548\u8fc7\u671f\u9a8c\u8bc1\uff0c\u81ea\u52a8\u5173\u95ed");
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5b9e\u7269\u81ea\u52a8\u4e0b\u67b6\u5931\u6548\u8fc7\u671f\u9a8c\u8bc1\uff0c\u81ea\u52a8\u5173\u95ed1");
                    return false;
                }
            } else if (itemKey.isSelfAppItemMode()) {
                if (itemKey.getAppItem().getValidEndDate() != null && new Date().after(itemKey.getAppItem().getValidEndDate())) {
                    LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5b9e\u7269\u81ea\u52a8\u4e0b\u67b6\u5931\u6548\u8fc7\u671f\u9a8c\u8bc1\uff0c\u81ea\u52a8\u5173\u95ed2");
                    return false;
                }
                if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                    LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5b9e\u7269\u81ea\u52a8\u4e0b\u67b6\u5931\u6548\u8fc7\u671f\u9a8c\u8bc1\uff0c\u81ea\u52a8\u5173\u95ed3");
                    return false;
                }
            }
        }
        if ("virtual".equals(itemKey.getItemType())) {
            if (StringUtils.isBlank((CharSequence)itemKey.getApp().getVirtualExchangeUrl())) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u865a\u62df\u5546\u54c1\u6821\u9a8c");
                return false;
            }
            if (null == itemKey.getAppItem() || itemKey.getAppItem().getDeleted().booleanValue()) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u865a\u62df\u5546\u54c1\u6821\u9a8c1");
                return false;
            }
            if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u865a\u62df\u5546\u54c1\u6821\u9a8c2");
                return false;
            }
            PriceDegree priceDegree = new PriceDegree(itemKey.getAppItem().getCustomPrice());
            if (!priceDegree.isDegreeExist(prize.getFacePrice())) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u865a\u62df\u5546\u54c1\u6821\u9a8c3");
                return false;
            }
        }
        List itemKeyVOs = Lists.newArrayList((Object[])new ItemKeyVO[]{new ItemKeyVO(itemKey)});
        if ((itemKeyVOs = this.remoteAddrLimitService.mobileIndexAddrLimitFilter(itemKeyVOs, order.getIp())).isEmpty()) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5730\u57df\u9650\u5236\u9a8c\u8bc1");
            return false;
        }
        Integer actualPrice = null;
        if ("alipay".equals(itemKey.getItemType()) || "phonebill".equals(itemKey.getItemType()) || "qb".equals(itemKey.getItemType())) {
            actualPrice = Integer.valueOf(prize.getFacePrice());
        } else if ("object".equals(itemKey.getItemType()) || "coupon".equals(itemKey.getItemType())) {
            actualPrice = this.calculateNormalActualPrice(itemKey, null);
        }
        if (actualPrice != null && actualPrice > 0 && ("alipay".equals(itemKey.getItemType()) || "phonebill".equals(itemKey.getItemType()) || "qb".equals(itemKey.getItemType())) && (money = (duibaM = this.duibaRemainingMoneyDAO.findDuibaAccountMoney()).getMoney()) < (long)actualPrice.intValue()) {
            LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5f00\u53d1\u8005\u4f59\u989d\uff0c\u65e5\uff0c\u6708\u9884\u7b97\u9a8c\u8bc11");
            return false;
        }
        if (actualPrice != null && actualPrice > 0) {
            if (!this.isDayBudgetEnough(itemKey)) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5f00\u53d1\u8005\u4f59\u989d\uff0c\u65e5\uff0c\u6708\u9884\u7b97\u9a8c\u8bc12");
                return false;
            }
            if (!this.isMonthBudgetEnough(itemKey)) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5f00\u53d1\u8005\u4f59\u989d\uff0c\u65e5\uff0c\u6708\u9884\u7b97\u9a8c\u8bc13");
                return false;
            }
            AppDO app = this.remoteAppService.find(order.getAppId());
            money = this.duibaRemainingMoneyDAO.findByDeveloperId(app.getDeveloperId());
            if (money != null && (long)actualPrice.intValue() > money.getMoney()) {
                LogUtil.logPluginKan((String)"validItemKeyCheck    =====> \u5f00\u53d1\u8005\u4f59\u989d\uff0c\u65e5\uff0c\u6708\u9884\u7b97\u9a8c\u8bc14");
                return false;
            }
        }
        return true;
    }

    @Override
    public void doWinPrize(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options, String ip, String ua, String os, ActivityPluginDto pluDto) throws Exception {
        Long couponId = null;
        ActivityOrderSyncEvent.ActivityOrderPluginContext context = new ActivityOrderSyncEvent.ActivityOrderPluginContext();
        try {
            DubboResult result;
            if (winOption.getId() != null) {
                LogUtil.logPluginKan((String)"===============\u300b    \u6263\u5e93\u5b58  \u5f00\u59cb");
                DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
                Object obj = context.getAttribute("couponId");
                if (null != obj) {
                    couponId = (Long)obj;
                }
            }
            if (!(result = this.remoteActivityOrderService.consumeCreditsSuccess(order.getOrderNum(), winOption.getId(), winOption.getDescription(), winOption.getPrizeType(), winOption.getFacePrice(), winOption.getAppItemId(), winOption.getItemId(), winOption.getgId(), winOption.getgType(), couponId)).isSuccess()) {
                LogUtil.logPluginKan((String)"===============\u300b    \u66f4\u65b0\u8ba2\u5355\u4e2d\u5956\u4fe1\u606f  \u5931\u8d25");
                throw new Exception("\u66f4\u65b0\u62bd\u5956\u8ba2\u5931\u8d25");
            }
            LogUtil.logPluginKan((String)("===============\u300b    winOption.getPrizeName()" + winOption.getPrizeName()));
            if (winOption.getWinLimit() != null && !winOption.getPrizeType().equals("lucky") && !winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
                this.consumerActivityLimitService.incrConsumerWinOptionNum(order.getConsumerId(), order.getDuibaActivityId(), "plugin" + winOption.getId());
            }
        }
        catch (Exception e) {
            LogUtil.logPluginKan((String)"===============\u300b    \u56de\u6eda\u5e93\u5b58");
            DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
            LogUtil.logPluginKanEorror((String)("className: " + this.getClass().getName() + " method: doWinPrize"), (Throwable)e);
            throw e;
        }
        finally {
            this.activityPluginVistService.updateActivityPluginInfo(order.getDuibaActivityId(), 0);
        }
        this.remoteActivityOrderService.exchangeStatusToWait(order.getOrderNum());
        if (!winOption.getPrizeType().equals("lucky") && !winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            this.activityPluginFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(), order.getOrderNum(), null, winOption.getPrizeType());
        }
        LogUtil.logPluginKan((String)("===============\u300b   \u4e2d\u5956\u7c7b\u578b\uff1a" + winOption.getPrizeType()));
        if (winOption.getPrizeType().equals("lucky")) {
            LogUtil.logPluginKan((String)"===============\u300b    \u798f\u888b  \u53d1\u8d77\u5f02\u6b65\u8bf7\u6c42");
            this.luckBagFlowWorker.asyncHttpRequest(order.getOrderNum(), order.getConsumerId(), order.getDuibaActivityId(), order.getAppId(), ip, ua, pluDto.getTag(), "40003", "2", order.getOrderNum(), os, ua, options, pluDto);
        }
        if (winOption.getPrizeType().equals("coupon") || winOption.getPrizeType().equals("virtual")) {
            try {
                LogUtil.logPluginKan((String)"===============\u300b    \u4f18\u60e0\u5238\u81ea\u52a8\u9886\u5956");
                this.activityPluginFlowworkService.autoTakePrize(order.getOrderNum(), order.getConsumerId(), order.getAppId(), ip, ua);
            }
            catch (Exception e) {
                LogUtil.logPluginKanEorror((String)"\u4f18\u60e0\u5238\u9886\u5956\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private Integer calculateNormalActualPrice(ItemKey key, String degree) {
        if (key.isItemMode() || key.isDuibaAppItemMode()) {
            if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
                if (degree == null) {
                    return key.getItem().getActualPrice();
                }
                throw new RuntimeException("\u5238\u6216\u8005\u5b9e\u7269\u7c7b\u5546\u54c1\u4e0d\u7528\u4f20\u6863\u4f4d\u4fe1\u606f\uff01");
            }
            if (key.getItem().getType().equals("phonebill") || key.getItemType().equals("phoneflow") || key.getItemType().equals("phonebillDingzhi")) {
                throw new RuntimeException("\u8bdd\u8d39\u548c\u6d41\u91cf\u5546\u54c1\u4e0d\u8d70\u8fd9\u4e2a\u65b9\u6cd5\uff01");
            }
            if (key.getItemType().equals("alipay") || key.getItemType().equals("qb") || key.getItemType().equals("alipayfast") || key.getItemType().equals("alipaycode")) {
                Integer price;
                if (degree == null) {
                    throw new RuntimeException("\u76f4\u5145\u7c7b\u5546\u54c1\u4e0d\u53ef\u4ee5\u6ca1\u6709\u6863\u4f4d\u4fe1\u606f\uff01");
                }
                Integer actualPrice = price = Integer.valueOf(Integer.valueOf(degree) * 100);
                CenterConfigDO ccDO = null;
                if (key.getItem().getType().equals("alipay")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipay-rate");
                } else if (key.getItem().getType().equals("qb")) {
                    ccDO = this.remoteCenterConfigService.findByType("qb-rate");
                } else if (key.getItem().getType().equals("alipayfast")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipayfast-rate");
                } else if (key.getItem().getType().equals("alipaycode")) {
                    ccDO = this.remoteCenterConfigService.findByType("alipaycode-rate");
                } else {
                    throw new RuntimeException("\u6ca1\u6709\u6b64\u5546\u54c1\u7684\u8d39\u7387\u4fe1\u606f\uff01");
                }
                String rateString = null;
                rateString = ccDO.getValue() != null ? ccDO.getValue() : ccDO.getFloatValue().toString();
                BigDecimal ret = new BigDecimal(price).multiply(new BigDecimal(rateString));
                actualPrice = (int)Math.ceil(ret.doubleValue());
                return actualPrice;
            }
            throw new RuntimeException("\u65e0\u6b64\u5546\u54c1\u7c7b\u578b\uff01");
        }
        if (key.isSelfAppItemMode()) {
            if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
                return 0;
            }
            if ("virtual".equals(key.getItemType())) {
                return 0;
            }
            throw new RuntimeException("\u672a\u77e5\u7684\u81ea\u6709\u5546\u54c1\u7c7b\u578b\uff01");
        }
        throw new RuntimeException("\u65e0\u6b64\u6a21\u5f0f\u7c7b\u578b\uff01");
    }

    private Integer calculateMinActualPrice(ItemKey key) {
        if (key.getItemType().equals("alipay") || key.getItemType().equals("qb") || key.getItemType().equals("alipayfast") || key.getItemType().equals("alipaycode")) {
            PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
            String minDegree = pd.getMinDegreeKey();
            return this.calculateNormalActualPrice(key, minDegree);
        }
        if (key.getItemType().equals("phonebill") || key.getItemType().equals("phoneflow")) {
            return 100;
        }
        if (key.getItemType().equals("coupon") || key.getItemType().equals("object")) {
            return this.calculateNormalActualPrice(key, null);
        }
        if (key.getItemType().equals("phonebillDingzhi")) {
            return key.getItem().getFacePrice();
        }
        return 0;
    }

    public boolean isMonthBudgetEnough(ItemKey key) {
        AppDO app = key.getApp();
        if (key.isItemMode() || key.isDuibaAppItemMode()) {
            if (app.getBudget() == null) {
                return true;
            }
            if (app.getBudgetRemain() == null) {
                throw new RuntimeException("\u6708\u9884\u7b97\u4f59\u989d\u6570\u636e\u9519\u8bef\uff01");
            }
            if ("alipay".equals(key.getItemType()) || "qb".equals(key.getItemType()) || "phonebill".equals(key.getItemType()) || "phoneflow".equals(key.getItemType())) {
                if (app.getBudgetRemain() < this.calculateMinActualPrice(key)) {
                    return false;
                }
            } else if (key.getItem().isOpTypeItem(11)) {
                Long diffPrice = key.getItem().getActualPrice().longValue() - key.getItem().getSalePrice();
                if ((long)app.getDayBudgetRemain().intValue() < diffPrice) {
                    return false;
                }
            } else if (app.getDayBudgetRemain() < key.getItem().getActualPrice()) {
                return false;
            }
            return true;
        }
        if (key.isSelfAppItemMode()) {
            return true;
        }
        throw new RuntimeException("\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
    }

    private boolean isDayBudgetEnough(ItemKey key) {
        AppDO app = key.getApp();
        if (key.isItemMode() || key.isDuibaAppItemMode()) {
            if (app.getDayBudget() == null) {
                return true;
            }
            if (app.getDayBudgetRemain() == null) {
                throw new RuntimeException("\u65e5\u9884\u7b97\u4f59\u989d\u6570\u636e\u9519\u8bef\uff01");
            }
            if ("alipay".equals(key.getItemType()) || "qb".equals(key.getItemType()) || "alipayfast".equals(key.getItemType()) || "alipaycode".equals(key.getItemType())) {
                if (app.getDayBudgetRemain() < this.calculateMinActualPrice(key)) {
                    return false;
                }
            } else if (key.getItem().isOpTypeItem(11)) {
                Long diffPrice = key.getItem().getActualPrice().longValue() - key.getItem().getSalePrice();
                if ((long)app.getDayBudgetRemain().intValue() < diffPrice) {
                    return false;
                }
            } else if (app.getDayBudgetRemain() < key.getItem().getActualPrice()) {
                return false;
            }
            return true;
        }
        if (key.isSelfAppItemMode()) {
            return true;
        }
        throw new RuntimeException("\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
    }
}

