/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrderTextChangeDao;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersSequenceDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.QuizzMQSend;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrderTextChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuizzOrderTextChangeServiceImpl
implements QuizzOrderTextChangeService {
    @Autowired
    private QuizzOrdersSequenceDao quizzOrdersSequenceDao;
    @Autowired
    private QuizzMQSend quizzMQSend;
    @Autowired
    private QuizzOrderTextChangeDao quizzOrderTextChangeDao;

    @Override
    public void insert(QuizzOrdersDto quizzOrdersDto) {
        Preconditions.checkNotNull((Object)quizzOrdersDto, (Object)"quizzOrdersEntity is null ");
        Long id = this.quizzOrdersSequenceDao.getId();
        int ret = this.quizzOrderTextChangeDao.insert((QuizzOrdersEntity)((Object)BeanUtils.copy((Object)quizzOrdersDto, QuizzOrdersEntity.class)), id);
        quizzOrdersDto.setId(id);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(quizzOrdersDto.getConsumerId(), quizzOrdersDto.getId());
        }
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        Preconditions.checkNotNull((Object)bizId, (Object)"bizId is null ");
        int ret = this.quizzOrderTextChangeDao.updateDeveloperBizId(consumerId, id, bizId);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"bizId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        Preconditions.checkNotNull((Object)mainOrderId, (Object)"mainOrderId is null ");
        Preconditions.checkNotNull((Object)mainOrderNum, (Object)"mainOrderNum is null ");
        int ret = this.quizzOrderTextChangeDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public QuizzOrdersDto find(Long consumerId, Long id) {
        QuizzOrdersEntity entity = this.quizzOrderTextChangeDao.find(consumerId, id);
        return (QuizzOrdersDto)BeanUtils.copy((Object)((Object)entity), QuizzOrdersDto.class);
    }
}

