/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDetailDto;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobConfigDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobBarCategoryRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryActivityRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryService;
import cn.com.duiba.activity.center.biz.service.rob.impl.RobCategoryBarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RobCategoryServiceImpl
implements RobCategoryService {
    private static final Logger log = LoggerFactory.getLogger(RobCategoryBarServiceImpl.class);
    private static final Long DEFAULT_BAR_ID = 1L;
    @Autowired
    private RobCategoryBarAppRelationDao robCategoryBarAppRelationDao;
    @Autowired
    private RobBarCategoryRelationDao robBarCategoryRelationDao;
    @Autowired
    private RobCategoryActivityRelationDao robCategoryActivityRelationDao;
    @Autowired
    private RobCategoryDao robCategoryDao;
    @Autowired
    private TodayRobConfigDao todayRobConfigDao;

    @Override
    public List<RobCategoryEntity> getAllCategory() {
        return this.robCategoryDao.getAllCategory();
    }

    @Override
    public List<RobCategoryEntity> getByAppId(Long appId) {
        RobCategoryBarAppRelationEntity entity = this.robCategoryBarAppRelationDao.getByAppId(appId);
        Long barId = null;
        barId = entity == null ? DEFAULT_BAR_ID : entity.getBarId();
        final List<Long> categoryIds = this.robBarCategoryRelationDao.getRobCategoryIdsByBarId(barId);
        if (CollectionUtils.isEmpty(categoryIds)) {
            log.error("\u5206\u7c7b\u680f\u6ca1\u6709\u914d\u7f6e\u4eca\u65e5\u5fc5\u62a2\u5206\u7c7b");
            return Collections.emptyList();
        }
        List<RobCategoryEntity> robCategoryEntityList = this.robCategoryDao.getRobCategoryByIds(categoryIds);
        if (CollectionUtils.isEmpty(categoryIds)) {
            log.error("\u4eca\u65e5\u5fc5\u62a2\u5206\u7c7b\u4e0d\u5b58\u5728");
            return Collections.emptyList();
        }
        Collections.sort(robCategoryEntityList, new Comparator<RobCategoryEntity>(){

            @Override
            public int compare(RobCategoryEntity o1, RobCategoryEntity o2) {
                if (categoryIds.indexOf(o1.getId()) > categoryIds.indexOf(o2.getId())) {
                    return 1;
                }
                if (categoryIds.indexOf(o1.getId()) < categoryIds.indexOf(o2.getId())) {
                    return -1;
                }
                return 0;
            }
        });
        return robCategoryEntityList;
    }

    @Override
    public List<TodayRobConfigDto> getByCategoryId(Long categoryId, int offset, int pageSize) {
        List<Long> robActivityIds = this.robCategoryActivityRelationDao.getPageRobActivityIdsByCategoryId(categoryId, offset, pageSize);
        List<TodayRobConfigDto> todayRobConfigDtoList = new ArrayList<TodayRobConfigDto>();
        if (CollectionUtils.isEmpty(robActivityIds)) {
            return todayRobConfigDtoList;
        }
        todayRobConfigDtoList = this.todayRobConfigDao.findTodayRobConfigForAppByIds(robActivityIds);
        if (CollectionUtils.isEmpty(todayRobConfigDtoList)) {
            return todayRobConfigDtoList;
        }
        this.todayRobConfigDtoListSort(robActivityIds, todayRobConfigDtoList);
        return todayRobConfigDtoList;
    }

    private void todayRobConfigDtoListSort(final List<Long> robActivityIds, List<TodayRobConfigDto> todayRobConfigDtoList) {
        Collections.sort(todayRobConfigDtoList, new Comparator<TodayRobConfigDto>(){

            @Override
            public int compare(TodayRobConfigDto o1, TodayRobConfigDto o2) {
                if (robActivityIds.indexOf(o1.getId()) > robActivityIds.indexOf(o2.getId())) {
                    return 1;
                }
                if (robActivityIds.indexOf(o1.getId()) < robActivityIds.indexOf(o2.getId())) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public List<RobActivityDto> getForManageByCategoryId(Long categoryId) {
        List<Long> activityIds = this.robCategoryActivityRelationDao.getAllRobActivityIdsByCategoryId(categoryId);
        List<RobActivityDto> robActivityDtoList = new ArrayList<RobActivityDto>();
        if (CollectionUtils.isEmpty(activityIds)) {
            return robActivityDtoList;
        }
        int totalCount = activityIds.size();
        if (totalCount > 50) {
            int pageSize = 50;
            for (int i = 0; i < totalCount; i += pageSize) {
                List<Long> newlist = null;
                newlist = i + pageSize > totalCount ? activityIds.subList(i, totalCount) : activityIds.subList(i, i + pageSize);
                List<RobActivityDto> robActivityDtos = this.todayRobConfigDao.findTodayRobConfigForManagerByIds(newlist);
                if (robActivityDtos == null) continue;
                robActivityDtoList.addAll(robActivityDtos);
            }
        } else {
            robActivityDtoList = this.todayRobConfigDao.findTodayRobConfigForManagerByIds(activityIds);
        }
        if (robActivityDtoList.isEmpty()) {
            return robActivityDtoList;
        }
        this.robActivityDtoListSort(activityIds, robActivityDtoList);
        return robActivityDtoList;
    }

    private void robActivityDtoListSort(final List<Long> activityIds, List<RobActivityDto> robActivityDtoList) {
        Collections.sort(robActivityDtoList, new Comparator<RobActivityDto>(){

            @Override
            public int compare(RobActivityDto o1, RobActivityDto o2) {
                if (activityIds.indexOf(o1.getId()) > activityIds.indexOf(o2.getId())) {
                    return 1;
                }
                if (activityIds.indexOf(o1.getId()) < activityIds.indexOf(o2.getId())) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public List<RobCategoryEntity> getCategoryPage(String name, String title, Integer offset, Integer pageSize) {
        if (offset == null || offset < 0) {
            offset = 0;
        }
        if (pageSize == null || pageSize < 1) {
            pageSize = 20;
        }
        return this.robCategoryDao.getPageRobCategory(name, title, offset, pageSize);
    }

    @Override
    public Integer countByNameAndTitle(String name, String title) {
        return this.robCategoryDao.countByNameAndTitle(name, title);
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean deleteById(Long id) {
        if (id.equals(1L)) {
            log.error("\u9ed8\u8ba4[\u5168\u90e8]\u5206\u7c7b\u7981\u6b62\u5220\u9664");
            return false;
        }
        this.robBarCategoryRelationDao.deleteByCategoryId(id);
        this.robCategoryActivityRelationDao.deleteByCategoryId(id);
        this.robCategoryDao.deleteById(id);
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean insertCategory(RobCategoryDetailDto robCategoryDetailDto) {
        RobCategoryEntity robCategoryEntity = new RobCategoryEntity(robCategoryDetailDto.getName(), robCategoryDetailDto.getTitle());
        Long categoryId = this.robCategoryDao.insertRobCategory(robCategoryEntity);
        if (categoryId == null || categoryId < 1L) {
            return false;
        }
        Map activitIdAndPayloadMap = robCategoryDetailDto.getActivitIdAndPayloadMap();
        if (!CollectionUtils.isEmpty((Map)activitIdAndPayloadMap)) {
            for (Map.Entry entry : activitIdAndPayloadMap.entrySet()) {
                this.robCategoryActivityRelationDao.insertRobCategoryActivityRelation(categoryId, (Long)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchDeleteCategoryActivityRelation(Long categoryId, List<Long> activityIds) {
        for (Long activityId : activityIds) {
            this.robCategoryActivityRelationDao.deleteByActivityIdAndCategoryId(activityId, categoryId);
        }
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchUpdateRobCategoryActivityRelationPayload(RobCategoryDetailDto robCategoryDetailDto) {
        Long categoryId = robCategoryDetailDto.getCategoryId();
        String name = robCategoryDetailDto.getName();
        String title = robCategoryDetailDto.getTitle();
        this.robCategoryDao.updateRobCategory(categoryId, name, title);
        Map activitIdAndPayloadMap = robCategoryDetailDto.getActivitIdAndPayloadMap();
        if (activitIdAndPayloadMap != null) {
            for (Map.Entry entry : activitIdAndPayloadMap.entrySet()) {
                this.robCategoryActivityRelationDao.updateRobCategoryActivityRelation(categoryId, (Long)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return true;
    }

    @Override
    public List<RobCategoryEntity> getRobCategorysByIds(List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return Collections.emptyList();
        }
        return this.robCategoryDao.getRobCategorysByIds(categoryIdList);
    }

    @Override
    public RobCategoryEntity getCategoryById(Long id) {
        return this.robCategoryDao.getCategoryById(id);
    }
}

