/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.sign.event;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.activity.center.biz.sign.event.SignEventsRegister;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsFailEvent;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsSuccessEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignEventsDispatcher {
    private static Logger log = LoggerFactory.getLogger(SignEventsDispatcher.class);
    private static SignEventsDispatcher dispatcher = new SignEventsDispatcher();

    public static SignEventsDispatcher get() {
        return dispatcher;
    }

    public void dispatchEvent(DuibaEvent<?> e) {
        if (e instanceof ActivityOrdersEvent) {
            this.processActivityOrdersEvent((ActivityOrdersEvent)e);
        }
    }

    private void processActivityOrdersEvent(final ActivityOrdersEvent event) {
        final List<ActivityOrdersEvent.ActivityOrdersEventListener> listeners = SignEventsRegister.get().activityOrderListener;
        if (!listeners.isEmpty()) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    for (ActivityOrdersEvent.ActivityOrdersEventListener l : new ArrayList(listeners)) {
                        try {
                            if (event.getType() == ActivityOrdersEvent.ActivityOrdersEventType.OnOrderCreate) {
                                l.onOrderCreate(event.getData());
                                continue;
                            }
                            if (event.getType() == ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess) {
                                l.onOrderSuccess(event.getData());
                                continue;
                            }
                            if (event.getType() != ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail) continue;
                            l.onOrderFail(event.getData());
                        }
                        catch (Exception e) {
                            log.error("processActivityOrderEvent", (Throwable)e);
                        }
                    }
                }
            }, 5);
        }
    }

    public void triggerAfterActivityOrderCreate(ActivityOrderDto order) {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)) {
            try {
                p.afterOrderCreate(order);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }

    public void triggerBeforeActivityOrderComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)) {
            p.beforeStockComplete(order, option, context);
        }
    }

    public void triggerOnActivityOrderCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)) {
            try {
                p.beforeStockCompleteException(order, option, exception, context);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }

    public void dispatchAddCreditsFailEvent(final AddCreditsFailEvent event) {
        if (event.getException() != null) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    List<AddCreditsFailEvent.AddCreditsFailListener> listeners = SignEventsRegister.get().addCreditsFailListeners;
                    if (event.getActivityOrder() != null) {
                        for (AddCreditsFailEvent.AddCreditsFailListener l : listeners) {
                            try {
                                l.onAddActivityOrderFail(event.getActivityOrder(), event.getException());
                            }
                            catch (Exception e) {
                                log.error("dispatchAddCreditsFailEvent", (Throwable)e);
                            }
                        }
                    }
                }
            }, 1);
        }
    }

    public void dispatchAddCreditsSuccessEvent(final ConsumerCreditsSuccessEvent event) {
        ThreadPoolDuibaService.get().submit(new Runnable(){

            @Override
            public void run() {
                List<AddCreditsSuccessEvent.AddCreditsSuccessListener> listeners = SignEventsRegister.get().addCreditsSuccessListeners;
                if (event.getActivityOrder() != null) {
                    for (AddCreditsSuccessEvent.AddCreditsSuccessListener l : listeners) {
                        try {
                            l.onAddOrderSuccess(event.getActivityOrder());
                        }
                        catch (Exception e) {
                            log.error("dispatchAddCreditsSuccessEvent", (Throwable)e);
                        }
                    }
                }
            }
        }, 1);
    }
}

