/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrequentExchangeLimitService {
    private static Logger log = LoggerFactory.getLogger(FrequentExchangeLimitService.class);
    @Autowired
    private CacheClient memcachedClient;

    public boolean canPass(ConsumerDO consumer) {
        if (Environment.isDaily()) {
            return true;
        }
        Long time = (Long)this.memcachedClient.get("100-" + consumer.getId());
        return time == null || time <= new Date().getTime() - 3000L;
    }

    public void updateLast(ConsumerDO consumer) {
        this.memcachedClient.set("100-" + consumer.getId(), (Object)new Date().getTime(), 10);
    }

    public boolean canPass(Long consumerId, int s) {
        if (Environment.isDaily()) {
            return true;
        }
        try {
            if (Environment.isDaily()) {
                return true;
            }
            String key = "100-" + consumerId + "-lottery";
            Long time = (Long)this.memcachedClient.get(key);
            if (time != null) {
                if (time > new Date().getTime() - (long)s * 1000L) {
                    return false;
                }
            } else {
                this.memcachedClient.set(key, (Object)new Date().getTime(), 2);
            }
        }
        catch (Exception e) {
            log.error("canPass", (Throwable)e);
        }
        return true;
    }

    public Integer getTodayTradingCount(Long appId) {
        String APP_NAMESPACE = "app_trading";
        String key = APP_NAMESPACE + appId;
        Integer appItemCounter = 0;
        try {
            appItemCounter = (Integer)this.memcachedClient.get(key);
            if (appItemCounter == null) {
                appItemCounter = 0;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
        return appItemCounter;
    }

    @Deprecated
    public MemLock lockPrize(Long activityId, String activityType, Long prizeId) {
        MemLock memLock = new MemLock();
        memLock.setLocked(true);
        memLock.setTicket(String.valueOf(System.currentTimeMillis()));
        return memLock;
    }

    @Deprecated
    public void unlockPrize(Long activity, String activityType, Long prizeId) {
    }
}

