/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemKeyStockServcie {
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemotePreStockService remotePreStockService;

    public Integer findRemaining(ItemKey itemKey) {
        return this.remotePreStockService.findRemaining(itemKey);
    }

    public boolean couponBatchCheck(ItemKey itemKey) {
        if ("coupon".equals(itemKey.getItemType())) {
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    return false;
                }
            } else if (itemKey.isSelfAppItemMode()) {
                if (itemKey.getAppItem().getValidEndDate() != null && new Date().after(itemKey.getAppItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                    return false;
                }
            }
        }
        return true;
    }
}

