/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.littleGame;

import cn.com.duiba.activity.center.api.dto.littlegame.LittleGameDto;
import cn.com.duiba.activity.center.api.remoteservice.littlegame.RemoteLittleGameBackendService;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteLittleGameBackendServiceImpl
implements RemoteLittleGameBackendService {
    private static Logger log = LoggerFactory.getLogger(RemoteLittleGameBackendServiceImpl.class);
    @Resource
    private LittleGameService littleGameService;

    public DubboResult<LittleGameDto> queryLittleGameById(Long id) {
        try {
            LittleGameDto dto;
            LittleGameEntity entity = this.littleGameService.selectById(id);
            if (entity == null) {
                dto = null;
            } else {
                dto = new LittleGameDto();
                ObjectUtil.convert((Object)((Object)entity), (Object)dto);
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.queryLittleGameById(" + id + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<LittleGameDto>> queryLittleGameByPage(String title, Integer offset, Integer max) {
        try {
            ArrayList rs;
            List<LittleGameEntity> list = this.littleGameService.selectList(title, offset, max);
            if (list == null) {
                rs = null;
            } else {
                rs = Lists.newArrayList();
                ObjectUtil.convertList(list, (List)rs, LittleGameDto.class);
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.queryLittleGameByPage(" + title + "," + offset + "," + max + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> queryLittleGameCount(String title) {
        try {
            Long count = this.littleGameService.selectCount(title);
            return DubboResult.successResult((Object)count);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.queryLittleGameCount(" + title + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> saveOrUpdateLittleGame(LittleGameDto dto) {
        try {
            Long rs;
            if (dto == null) {
                throw new Exception("dto is null!!!");
            }
            LittleGameEntity entity = new LittleGameEntity();
            ObjectUtil.convert((Object)dto, (Object)((Object)entity));
            if (dto.getId() == null) {
                this.littleGameService.insert(entity);
                rs = entity.getId();
            } else {
                this.littleGameService.update(entity);
                rs = entity.getId();
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.saveOrUpdateLittleGame(" + dto.toString() + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> removeLittleGame(Long id) {
        try {
            LittleGameEntity entity = new LittleGameEntity();
            entity.setId(id);
            entity.setLittleGameDelete(true);
            this.littleGameService.update(entity);
            return DubboResult.successResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.removeLittleGame(" + id + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateCategoryId(Long id, Long categoryId) {
        try {
            this.littleGameService.updateCategoryId(id, categoryId);
            return DubboResult.successResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("RemoteLittleGameBackendService.updateCategoryId(" + id + "," + categoryId + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

