/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class GameCenterCommonSerice {
    private static final Logger log = LoggerFactory.getLogger(GameCenterCommonSerice.class);
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private DeveloperActBlackService developerActBlackService;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    @Autowired
    private ActivityShieldService gameCenterShieldService;
    @Autowired
    private GameCenterResourceLocationDao gameCenterResourceLocationDao;

    GameCenterCommonSerice() {
    }

    public Long findDeveloperIdByAppId(Long appId) {
        AppDO appDO = this.remoteAppService.find(appId);
        if (appDO == null) {
            log.error("appId is invalid: no record found: {}", (Object)appId);
            return null;
        }
        return appDO.getDeveloperId();
    }

    public boolean filterByActivityBlacklist(LittleGameEntity littleGameEntity, Long developerId) {
        return littleGameEntity.isOpenSwitch(1) && this.developerActBlackService.isExist(littleGameEntity.getId(), 47, developerId) != false;
    }

    public boolean filterBySpecify(LittleGameEntity littleGameEntity, Long appId) {
        return littleGameEntity.isOpenSwitch(0) && this.duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(littleGameEntity.getId(), appId, "littlegame") == null;
    }

    public boolean filterByShield(Long appId, Long littleGameId) {
        return this.gameCenterShieldService.findShield(appId, 47, littleGameId) != null;
    }

    public Long findLocationIdByName(String name) throws GameCenterException {
        GameCenterResourceLocationEntity entity = this.gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found:" + name);
        }
        return entity.getId();
    }
}

