/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.GameCenterCommonSerice;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.Utils;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameCenterHomeServiceImpl
implements GameCenterHomeService {
    @Autowired
    private GameCenterResourceDao gameCenterResourceDao;
    @Autowired
    private LittleGameService littleGameService;
    @Autowired
    private GameCenterCommonSerice gameCenterCommonSerice;

    @Override
    public GameCenterHomeResourceListDto findResourceByLocationAndAppId(String locationName, Long appId, Integer offset, Integer max) throws GameCenterException {
        GameCenterHomeResourceListDto gameCenterHomeResourceListDto = new GameCenterHomeResourceListDto();
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByLocationId(this.gameCenterCommonSerice.findLocationIdByName(locationName));
        if (CollectionUtils.isEmpty(entities)) {
            return gameCenterHomeResourceListDto;
        }
        ArrayList<GameCenterHomeResourceDto> gameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        Long developerId = this.gameCenterCommonSerice.findDeveloperIdByAppId(appId);
        if (developerId == null) {
            return gameCenterHomeResourceListDto;
        }
        for (GameCenterResourceEntity gameCenterResourceEntity : entities) {
            LittleGameEntity littleGameEntity;
            if (gameCenterResourceEntity.getActivityType() != 47 || Utils.filterLittleGameByStatus(littleGameEntity = this.littleGameService.selectById(gameCenterResourceEntity.getActivityId()), gameCenterResourceEntity.getActivityId()) || this.gameCenterCommonSerice.filterByActivityBlacklist(littleGameEntity, developerId) || this.gameCenterCommonSerice.filterBySpecify(littleGameEntity, appId) || this.gameCenterCommonSerice.filterByShield(appId, littleGameEntity.getId())) continue;
            GameCenterHomeResourceDto temp = new GameCenterHomeResourceDto();
            temp.setActivityId(gameCenterResourceEntity.getActivityId());
            temp.setActivityType(gameCenterResourceEntity.getActivityType());
            temp.setGmtCreate(gameCenterResourceEntity.getGmtCreate());
            temp.setGmtModified(gameCenterResourceEntity.getGmtModified());
            temp.setLocationId(gameCenterResourceEntity.getResourceLocationId());
            temp.setTitle(littleGameEntity.getLittleGameTitle());
            temp.setDescription(littleGameEntity.getLittleGameRecomDescribe());
            temp.setBannerImg(littleGameEntity.getLittleGameBannerImg());
            temp.setRecommendImg(littleGameEntity.getLittleGameSmallImg());
            temp.setIconImg(littleGameEntity.getLittleGameIconImg());
            temp.setInfoType("25");
            temp.setInfo(gameCenterResourceEntity.getActivityId());
            temp.setLink("/littleGame/start?littleGameId=" + String.valueOf(gameCenterResourceEntity.getActivityId()) + "&startSource=null&dbnewopen");
            gameCenterHomeResourceDtoList.add(temp);
        }
        if (gameCenterHomeResourceDtoList.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }
        Collections.sort(gameCenterHomeResourceDtoList, new Comparator<GameCenterHomeResourceDto>(){

            @Override
            public int compare(GameCenterHomeResourceDto o1, GameCenterHomeResourceDto o2) {
                return o2.getGmtModified().compareTo(o1.getGmtModified());
            }
        });
        gameCenterHomeResourceListDto.setCount(Integer.valueOf(gameCenterHomeResourceDtoList.size()));
        gameCenterHomeResourceListDto.setGameCenterHomeResourceDtoList(Utils.subList(gameCenterHomeResourceDtoList, offset, max));
        return gameCenterHomeResourceListDto;
    }
}

