/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GeneralActivityItem;
import cn.com.duiba.activity.center.biz.service.gamecenter.MultiActivityQueryingService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MultiActivityQueryingServiceImpl
implements MultiActivityQueryingService {
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private DuibaActivityService duibaActivityService;
    @Resource
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Resource
    private DuibaSecondsKillActivityService duibaSecondsKillActivityService;
    @Resource
    DuibaSecondsKillActivityAppSpecifyService duibaSecondsKillActivityAppSpecifyService;
    @Resource
    private DuibaNgameService duibaNgameService;
    @Resource
    private DuibaNgameAppSpecifyService duibaNgameAppSpecifyService;
    @Resource
    private DuibaQuestionAnswerService duibaQuestionAnswerService;
    @Resource
    private DuibaQuestionAnswerAppSpecifyService duibaQuestionAnswerAppSpecifyService;
    @Resource
    private RemoteDuibaSeckillService duibaSeckillService;
    @Resource
    private RemoteDuibaSeckillAppSpecifyService remoteDuibaSeckillAppSpecifyService;
    @Resource
    private DuibaQuizzService duibaQuizzService;
    @Resource
    private DuibaQuizzAppSpecifyService duibaQuizzAppSpecifyService;
    @Resource
    private DuibaGuessService duibaGuessService;
    @Resource
    private DuibaGuessAppSpecifyService duibaGuessAppSpecifyService;
    @Resource
    private RemoteAppService remoteAppService;
    @Resource
    private DeveloperActBlackService developerActBlackService;
    @Resource
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    @Resource
    private DuibaActivityAppSpecifyService duibaActivityAppSpecifyService;

    @Override
    public GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType, Long activityId) throws GameCenterException {
        return this.findActivityByTypeAndIdWithFilterAll(activityType, activityId, null);
    }

    @Override
    public GeneralActivityItem findActivityByTypeAndIdWithFilter(Integer activityType, Long activityId, Long appId) throws GameCenterException {
        return this.findActivityByTypeAndIdWithFilterAll(activityType, activityId, appId);
    }

    private GeneralActivityItem findActivityByTypeAndIdWithFilterAll(Integer activityType, Long activityId, Long appId) throws GameCenterException {
        String description;
        String iconImg;
        String recImg;
        String bannerImg;
        String title;
        Long developerId = null;
        if (appId != null) {
            AppDO appDO = this.remoteAppService.find(appId);
            if (appDO == null) {
                throw new GameCenterException("APP\u4e0d\u5b58\u5728");
            }
            developerId = appDO.getDeveloperId();
        }
        switch (activityType) {
            case 8: {
                DuibaHdtoolDto duibaHdtoolDto = this.duibaHdtoolService.find(activityId);
                if (duibaHdtoolDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaHdtoolDto.getStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaHdtoolDto.getTitle();
                bannerImg = duibaHdtoolDto.getBannerImage();
                recImg = duibaHdtoolDto.getRecommendImage();
                iconImg = duibaHdtoolDto.getLogo();
                description = duibaHdtoolDto.getDescription();
                if (developerId != null && duibaHdtoolDto.isOpenSwitch(1) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaHdtoolDto.isOpenSwitch(0) || this.duibaHdtoolService.findSpecifyByHdToolIdAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 0: {
                DuibaActivityDto duibaActivityDto = this.duibaActivityService.find(activityId);
                if (duibaActivityDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaActivityDto.getStatus().intValue() != DuibaActivityDto.STATUS_STARTUP.intValue()) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaActivityDto.getTitle();
                bannerImg = duibaActivityDto.getIndexBannerImage();
                recImg = duibaActivityDto.getRecommendImage();
                iconImg = duibaActivityDto.getLogo();
                description = duibaActivityDto.getSubtitle();
                if (developerId != null && duibaActivityDto.isOpenSwitch(1) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaActivityDto.isOpenSwitch(0) || this.duibaActivityAppSpecifyService.findByDuibaActivityAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 2: {
                DuibaSingleLotteryDto duibaSingleLotteryDto = this.duibaSingleLotteryService.find(activityId);
                if (duibaSingleLotteryDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaSingleLotteryDto.getStatus().intValue() != DuibaSingleLotteryDto.STATUS_STARTUP.intValue()) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaSingleLotteryDto.getTitle();
                bannerImg = duibaSingleLotteryDto.getBannerImage();
                recImg = duibaSingleLotteryDto.getImage();
                iconImg = duibaSingleLotteryDto.getLogo();
                description = duibaSingleLotteryDto.getSubtitle();
                if (developerId != null && duibaSingleLotteryDto.isOpenSwitch(DuibaSingleLotteryDto.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaSingleLotteryDto.isOpenSwitch(DuibaSingleLotteryDto.SWITCHES_DIRECT.intValue()) || this.duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 30: {
                DuibaSecondsKillActivityDto duibaSecondsKillActivityDto = this.duibaSecondsKillActivityService.find(activityId);
                if (duibaSecondsKillActivityDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaSecondsKillActivityDto.getStatus().intValue() != DuibaSecondsKillActivityDto.STATUS_STARTUP.intValue()) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaSecondsKillActivityDto.getTitle();
                bannerImg = duibaSecondsKillActivityDto.getIndexBannerImage();
                recImg = duibaSecondsKillActivityDto.getRecommendImage();
                iconImg = duibaSecondsKillActivityDto.getLogo();
                description = duibaSecondsKillActivityDto.getNextTitle();
                if (developerId != null && duibaSecondsKillActivityDto.isOpenSwitch(DuibaSecondsKillActivityDto.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaSecondsKillActivityDto.isOpenSwitch(DuibaSecondsKillActivityDto.SWITCHES_DIRECT.intValue()) || this.duibaSecondsKillActivityAppSpecifyService.findByDuibaSecondsKillActivityAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 28: {
                DuibaNgameDto duibaNgameDto = this.duibaNgameService.find(activityId);
                if (duibaNgameDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaNgameDto.getGameStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaNgameDto.getTitle();
                bannerImg = duibaNgameDto.getBanner();
                recImg = duibaNgameDto.getRecommendImage();
                iconImg = duibaNgameDto.getLogo();
                description = "";
                if (developerId != null && duibaNgameDto.isOpenSwitch(1) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaNgameDto.isOpenSwitch(0) || this.duibaNgameAppSpecifyService.findByGameConfigAndAppId(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 40: {
                DuibaQuestionAnswerDto duibaQuestionAnswerDto = this.duibaQuestionAnswerService.find(activityId);
                if (duibaQuestionAnswerDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaQuestionAnswerDto.getStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaQuestionAnswerDto.getTitle();
                bannerImg = duibaQuestionAnswerDto.getBanner();
                recImg = duibaQuestionAnswerDto.getRecommendImage();
                iconImg = duibaQuestionAnswerDto.getLogo();
                description = "";
                if (developerId != null && duibaQuestionAnswerDto.isOpenSwitch(DuibaQuestionAnswerDto.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaQuestionAnswerDto.isOpenSwitch(DuibaQuestionAnswerDto.SWITCHES_DIRECT.intValue()) || this.duibaQuestionAnswerAppSpecifyService.findByQuestionAnswerIdAndAppId(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 31: {
                DuibaSeckillDO duibaSeckillDO = this.duibaSeckillService.find(activityId);
                if (duibaSeckillDO == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaSeckillDO.getStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaSeckillDO.getTitle();
                bannerImg = duibaSeckillDO.getBanner();
                recImg = duibaSeckillDO.getRecommendImage();
                iconImg = duibaSeckillDO.getLogo();
                description = "";
                if (developerId != null && duibaSeckillDO.isOpenSwitch(DuibaSeckillDO.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaSeckillDO.isOpenSwitch(DuibaSeckillDO.SWITCHES_DIRECT.intValue()) || this.remoteDuibaSeckillAppSpecifyService.findByDuibaSeckillAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 41: {
                DuibaQuizzDto duibaQuizzDto = this.duibaQuizzService.find(activityId);
                if (duibaQuizzDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaQuizzDto.getStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaQuizzDto.getTitle();
                bannerImg = duibaQuizzDto.getBanner();
                recImg = duibaQuizzDto.getRecommendImage();
                iconImg = duibaQuizzDto.getLogo();
                description = "";
                if (developerId != null && duibaQuizzDto.isOpenSwitch(DuibaQuizzDto.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaQuizzDto.isOpenSwitch(DuibaQuizzDto.SWITCHES_DIRECT.intValue()) || this.duibaQuizzAppSpecifyService.findByDuibaQuizzAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            case 42: {
                DuibaGuessDto duibaGuessDto = this.duibaGuessService.find(activityId);
                if (duibaGuessDto == null) {
                    throw new GameCenterException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                }
                if (duibaGuessDto.getStatus() != 1) {
                    throw new GameCenterException("\u6d3b\u52a8\u672a\u5f00\u542f");
                }
                title = duibaGuessDto.getTitle();
                bannerImg = duibaGuessDto.getBanner();
                recImg = duibaGuessDto.getRecommendImage();
                iconImg = duibaGuessDto.getLogo();
                description = "";
                if (developerId != null && duibaGuessDto.isOpenSwitch(DuibaGuessDto.SWITCHES_DEV_BLACKLIST.intValue()) && this.developerActBlackService.isExist(activityId, activityType, developerId).booleanValue()) {
                    throw new GameCenterException("\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4");
                }
                if (appId == null || !duibaGuessDto.isOpenSwitch(DuibaGuessDto.SWITCHES_DIRECT.intValue()) || this.duibaGuessAppSpecifyService.findByDuibaGuessAndApp(activityId, appId) != null) break;
                throw new GameCenterException("\u5b9a\u5411\u6d3b\u52a8");
            }
            default: {
                throw new GameCenterException("Activity type not support: " + activityType);
            }
        }
        GeneralActivityItem result = new GeneralActivityItem();
        result.setActivityId(activityId);
        result.setActivityType(activityType);
        result.setTitle(title);
        result.setBannerImg(bannerImg);
        result.setRecommendImg(recImg);
        result.setIconImg(iconImg);
        result.setDescription(description);
        return result;
    }

    static interface ErrorMsg {
        public static final String ACTIVITY_NOT_EXIST = "\u6d3b\u52a8\u4e0d\u5b58\u5728";
        public static final String ACTIVITY_NOT_OPEN = "\u6d3b\u52a8\u672a\u5f00\u542f";
        public static final String ACTIVITY_FILTER_BY_BLACKLIST = "\u88ab\u9ed1\u540d\u5355\u8fc7\u6ee4";
        public static final String ACTIVITY__DIRECT_ACTIVITY = "\u5b9a\u5411\u6d3b\u52a8";
        public static final String APP_NOT_EXIST = "APP\u4e0d\u5b58\u5728";
    }
}

