/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.luckbag;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagCallback;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagRequest;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.dcommons.flowwork.ActivityPluginFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.service.IEngineService;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="luckBagFlowWorker")
public class LuckBagFlowWorkerImpl
implements LuckBagCallback.LuckBagFlowWorker {
    private static Logger log = LoggerFactory.getLogger(LuckBagFlowWorkerImpl.class);
    @Autowired
    private ActivityPluginFlowworkService activityPluginFlowworkService;
    @Autowired
    private XMemCacheClient memCacheClient;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private IEngineService iEngineService;
    @Autowired
    private PluginFlowInnerService pluginFlowInnerService;

    @Override
    public void asyncHttpRequest(String orderId, Long consumerId, Long operatingAcitivityId, Long appId, String ip, String ua, String tag, String buttonType, String infoType, String info, String os, String userAgent, List<ActivityPrizeOptionDto> options, ActivityPluginDto pluDto) throws Exception {
        LuckBagRequest req = LuckBagRequest.buildRequestData("plugin_" + orderId, consumerId, operatingAcitivityId, appId, ip, ua, null, tag, os, options, pluDto);
        this.LuckBagRequestServer(req, new LuckBagCallBackResponse(orderId, consumerId, operatingAcitivityId, null, req), buttonType, infoType, info, os, userAgent);
    }

    public static String getUA(String userAgent) {
        if (userAgent == null) {
            return "unknown";
        }
        if ((userAgent = userAgent.toLowerCase()) != null) {
            if (userAgent.contains("ipad")) {
                return "IOS";
            }
            if (userAgent.contains("iphone")) {
                return "IOS";
            }
            if (userAgent.contains("android")) {
                return "Android";
            }
            if (userAgent.contains("macintosh")) {
                return "IOS";
            }
        }
        return "unknown";
    }

    private void LuckBagRequestServer(LuckBagRequest req, LuckBagCallback callback, String buttonType, String infoType, String info, String os, String userAgent) throws Exception {
        ObtainAdvertReq obtain = new ObtainAdvertReq();
        obtain.setConsumerId(req.getConsumerId());
        obtain.setUa(LuckBagFlowWorkerImpl.getUA(req.getUa()));
        obtain.setOrderId(req.getOrderId());
        obtain.setIp(req.getIp());
        obtain.setAppId(req.getAppId());
        obtain.setActivityId(req.getOperatingActivityId());
        obtain.setTimestamp(Long.valueOf(new Date().getTime()));
        obtain.setTag(req.getTag());
        obtain.setLoginType("1");
        obtain.setButtonType(buttonType);
        obtain.setInfoType(infoType);
        obtain.setInfo(info);
        obtain.setOs(os);
        obtain.setType("2");
        obtain.setUserAgent(userAgent);
        obtain.setActivityType(Integer.valueOf(1));
        ObtainAdvertRsp advert = null;
        try {
            advert = this.iEngineService.obtainAdvert(obtain);
            if (null == advert || !advert.isResult()) {
                LogUtil.logPluginKan((String)"===============\u300b    \u5e7f\u544a\u5e73\u53f0\u83b7\u53d6\u5377\u5f02\u5e38");
                callback.onException(new Exception("\u5e7f\u544a\u5e73\u53f0\u83b7\u53d6\u5377\u5f02\u5e38"));
                return;
            }
            callback.onFinish(advert);
        }
        catch (Exception e) {
            log.error("es submit obtain advert error", (Throwable)e);
            callback.onException(e);
        }
    }

    private class LuckBagCallBackResponse
    implements LuckBagCallback {
        private String orderId;
        private Long activityId;
        private LuckBagRequest req;

        public LuckBagCallBackResponse(String orderId, Long consumerId, Long activityId, Long orderExtraId, LuckBagRequest req) {
            this.orderId = orderId;
            this.activityId = activityId;
            this.req = req;
        }

        @Override
        public void onFinish(ObtainAdvertRsp advert) throws Exception {
            if (null == advert) {
                this.onException(new Exception("\u83b7\u53d6\u798f\u888b\u5931\u8d25"));
                return;
            }
            ActivityOrderDto order = (ActivityOrderDto)LuckBagFlowWorkerImpl.this.remoteActivityOrderService.findByOrderNum(this.orderId).getResult();
            LuckBagFlowWorkerImpl.this.activityPluginFlowworkService.insertCosumerExchanageRecord(this.req.getConsumerId(), this.orderId, advert.getEndValid(), order.getActivityOptionType());
            LuckBagFlowWorkerImpl.this.memCacheClient.getMemcachedClient().set(this.getMemKey(this.orderId), 10, (Object)JSONObject.toJSONString((Object)advert));
            LuckBagFlowWorkerImpl.this.remoteActivityOrderService.exchangeStatusToSuccess(this.orderId);
            LogUtil.logPluginKan((String)"===============\u300b    \u798f\u888b\u9886\u5956\u6210\u529f");
        }

        @Override
        public void onException(Exception ex) throws Exception {
            LogUtil.logPluginKan((String)("===============\u300b    \u798f\u888b\u9886\u5956\u5f02\u5e38     orderId\uff1a" + this.orderId));
            ActivityOrderDto order = (ActivityOrderDto)LuckBagFlowWorkerImpl.this.remoteActivityOrderService.findByOrderNum(this.orderId).getResult();
            ActivityPrizeOptionDto option = LuckBagFlowWorkerImpl.this.pluginFlowInnerService.awardThanks(this.activityId, order.getActivityType());
            LogUtil.logPluginKan((String)("===============\u300b    \u798f\u888b\u9886\u5956\u5f02\u5e38   \u5956\u54c1\u964d\u7ea7\u4e3a\u8c22\u8c22\u53c2\u4e0e  orderId\uff1a" + this.orderId));
            LuckBagFlowWorkerImpl.this.remoteActivityOrderService.consumeCreditsSuccessDowngrade(order.getOrderNum(), option.getId(), option.getPrizeName(), option.getPrizeType(), option.getFacePrice(), option.getAppItemId(), option.getItemId(), option.getgId(), option.getgType(), null);
        }

        private String getMemKey(String orderId) {
            return "MS_LUCK_BAG_CACHE-" + orderId;
        }
    }
}

