/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzBrickDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzBrickDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzBrickEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzBrickService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuizzBrickServiceImpl
implements DuibaQuizzBrickService {
    @Resource
    private DuibaQuizzBrickDao duibaQuizzBrickDao;
    @Resource
    private CacheClient cacheClient;

    private String getNoContentCacheKeyById(Long id) {
        return "activity-duibaQuizzBrickNoContentById_" + id;
    }

    private String getContentCacheKeyById(Long id) {
        return "activity-duibaQuizzBrickContentById_" + id;
    }

    @Override
    public DuibaQuizzBrickDto find(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (DuibaQuizzBrickDto)BeanUtils.copy((Object)this.duibaQuizzBrickDao.find(id), DuibaQuizzBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (String)this.cacheClient.getWithCacheLoader(this.getContentCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return DuibaQuizzBrickServiceImpl.this.duibaQuizzBrickDao.getBrickContentById(id);
            }
        });
    }

    @Override
    public DuibaQuizzBrickDto findNoContent(final Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (DuibaQuizzBrickDto)this.cacheClient.getWithCacheLoader(this.getNoContentCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<DuibaQuizzBrickDto>(){

            public DuibaQuizzBrickDto load() {
                return (DuibaQuizzBrickDto)BeanUtils.copy((Object)DuibaQuizzBrickServiceImpl.this.duibaQuizzBrickDao.findNoContent(id), DuibaQuizzBrickDto.class);
            }
        });
    }

    @Override
    public void insert(DuibaQuizzBrickDto duibaQuestionAnswerBrick) {
        DuibaQuizzBrickEntity entity = (DuibaQuizzBrickEntity)BeanUtils.copy((Object)duibaQuestionAnswerBrick, DuibaQuizzBrickEntity.class);
        this.duibaQuizzBrickDao.insert(entity);
        duibaQuestionAnswerBrick.setId(entity.getId());
    }

    @Override
    public void update4Admin(Long id, String title, String content, String md5) {
        this.duibaQuizzBrickDao.update4Admin(id, title, content, md5);
        this.cacheClient.remove(this.getContentCacheKeyById(id));
        this.cacheClient.remove(this.getNoContentCacheKeyById(id));
    }

    @Override
    public DuibaQuizzBrickDto findByTitle(String title) {
        return (DuibaQuizzBrickDto)BeanUtils.copy((Object)this.duibaQuizzBrickDao.findByTitle(title), DuibaQuizzBrickDto.class);
    }

    @Override
    public void open(Long id) {
        this.duibaQuizzBrickDao.open(id);
        this.cacheClient.remove(this.getNoContentCacheKeyById(id));
    }

    @Override
    public void disable(Long id) {
        this.duibaQuizzBrickDao.disable(id);
        this.cacheClient.remove(this.getNoContentCacheKeyById(id));
    }

    @Override
    public List<DuibaQuizzBrickDto> findPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(this.duibaQuizzBrickDao.findPage(queryMap), DuibaQuizzBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return this.duibaQuizzBrickDao.findPageCount();
    }

    @Override
    public List<DuibaQuizzBrickDto> findAll() {
        return BeanUtils.copyList(this.duibaQuizzBrickDao.findAll(), DuibaQuizzBrickDto.class);
    }
}

