/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuizzServiceImpl
implements DuibaQuizzService {
    @Resource
    private DuibaQuizzDao duibaQuizzDao;
    @Autowired
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuizzById_" + id;
    }

    @Override
    public DuibaQuizzDto find(Long id) {
        String key = this.getCacheKeyById(id);
        DuibaQuizzDto d = (DuibaQuizzDto)this.cacheClient.get(key);
        if (d == null) {
            DuibaQuizzEntity entity = this.duibaQuizzDao.find(id);
            if (entity == null) {
                return null;
            }
            d = (DuibaQuizzDto)BeanUtils.copy((Object)entity, DuibaQuizzDto.class);
            int cacheTime = 300;
            this.cacheClient.set(key, (Object)d, cacheTime);
        }
        return d;
    }

    @Override
    public String findTagById(Long id) {
        return this.duibaQuizzDao.findTagById(id);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Integer offset, Integer max) {
        List<DuibaQuizzEntity> byPage = this.duibaQuizzDao.findByPage(offset, max);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return this.duibaQuizzDao.findPageCount(paramMap);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return Collections.emptyList();
        }
        List<DuibaQuizzEntity> byPage = this.duibaQuizzDao.findByPage(paramMap);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public int updateStatus(Long id, int status) {
        int num = this.duibaQuizzDao.updateStatus(id, status);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return num;
    }

    @Override
    public int delete(Long id) {
        int num = this.duibaQuizzDao.delete(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return num;
    }

    @Override
    public int insert(DuibaQuizzDto duibaQuizzDto) {
        Preconditions.checkNotNull((Object)duibaQuizzDto);
        DuibaQuizzEntity entity = (DuibaQuizzEntity)BeanUtils.copy((Object)duibaQuizzDto, DuibaQuizzEntity.class);
        int num = this.duibaQuizzDao.insert(entity);
        duibaQuizzDto.setId(entity.getId());
        return num;
    }

    @Override
    public int updateInfoForm(DuibaQuizzDto duibaQuizzDto) {
        DuibaQuizzEntity entity = (DuibaQuizzEntity)BeanUtils.copy((Object)duibaQuizzDto, DuibaQuizzEntity.class);
        int num = this.duibaQuizzDao.updateInfoForm(entity);
        this.cacheClient.remove(this.getCacheKeyById(duibaQuizzDto.getId()));
        return num;
    }

    @Override
    public int updateTagById(Long id, String tag) {
        int num = this.duibaQuizzDao.updateTagById(id, tag);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return num;
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int num = this.duibaQuizzDao.updateAutoOffDateNull(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return num;
    }

    @Override
    public int updateSwitches(Long id, Long switches) {
        int num = this.duibaQuizzDao.updateSwitches(id, switches);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return num;
    }

    @Override
    public List<DuibaQuizzDto> findAutoOff() {
        List<DuibaQuizzEntity> autoOff = this.duibaQuizzDao.findAutoOff();
        if (CollectionUtils.isEmpty(autoOff)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(autoOff, DuibaQuizzDto.class);
    }

    @Override
    public List<DuibaQuizzDto> findAllByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<DuibaQuizzEntity> allByIds = this.duibaQuizzDao.findAllByIds(ids);
        if (CollectionUtils.isEmpty(allByIds)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(allByIds, DuibaQuizzDto.class);
    }

    @Override
    public List<AddActivityDto> findAllQuizz() {
        List<AddActivityEntity> allQuizz = this.duibaQuizzDao.findAllQuizz();
        if (CollectionUtils.isEmpty(allQuizz)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(allQuizz, AddActivityDto.class);
    }

    @Override
    public int update(DuibaQuizzDto duibaQuizzDto) {
        Preconditions.checkNotNull((Object)duibaQuizzDto);
        DuibaQuizzEntity copy = (DuibaQuizzEntity)BeanUtils.copy((Object)duibaQuizzDto, DuibaQuizzEntity.class);
        int num = this.duibaQuizzDao.update(copy);
        this.cacheClient.remove(this.getCacheKeyById(duibaQuizzDto.getId()));
        return num;
    }
}

